package com.xebialabs.xltest.fitnesse;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;

public class TestSummary {
    public final String name;
    public final Set<String> tags;
    public final long timestamp;
    public final int duration;
    public final int right;
    public final int wrong;
    public final String result;
    public final int exceptions;
    public final String firstError;

    public TestSummary(String name, Set<String> tags, long timestamp, int duration, int right, int wrong, String result, int exceptions, String firstError) {
        this.name = name;
        this.tags = tags;
        this.timestamp = timestamp;
        this.duration = duration;
        this.right = right;
        this.wrong = wrong;
        this.result = wrong + exceptions > 0 ? "FAILED" : "PASSED";
        this.exceptions = exceptions;
        this.firstError = firstError;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + (int) (duration ^ (duration >>> 32));
        result = prime * result + exceptions;
        result = prime * result + ((name == null) ? 0 : name.hashCode());
        result = prime * result + right;
        result = prime * result + ((tags == null) ? 0 : tags.hashCode());
        result = prime * result + (int) (timestamp ^ (timestamp >>> 32));
        result = prime * result + wrong;
        result = prime * result + ((firstError == null) ? 0 : firstError.hashCode());
        return result;
    }


    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        TestSummary other = (TestSummary) obj;
        if (duration != other.duration)
            return false;
        if (exceptions != other.exceptions)
            return false;
        if (name == null) {
            if (other.name != null)
                return false;
        } else if (!name.equals(other.name))
            return false;
        if (result == null) {
            if (other.result != null)
                return false;
        } else if (!result.equals(other.result))
            return false;
        if (right != other.right)
            return false;
        if (tags == null) {
            if (other.tags != null)
                return false;
        } else if (!tags.equals(other.tags))
            return false;
        if (timestamp != other.timestamp)
            return false;
        if (wrong != other.wrong)
            return false;
        if (firstError == null) {
            if (other.firstError != null)
                return false;
        } else if (!firstError.equals(other.firstError))
            return false;
        return true;
    }

    @Override
    public String toString() {
        JsonArrayBuilder tagBuilder = Json.createArrayBuilder();
        for (String s : tags) {
            tagBuilder.add(s);
        }
        JsonObjectBuilder obj = Json.createObjectBuilder();
        obj.add("type", "result")
                .add("name", name)
                // TODO: fix tags defined by test tools
//                .add("tags", tagBuilder)
                .add("timestamp", timestamp)
                .add("duration", duration)
                .add("right", right)
                .add("wrong", wrong)
                .add("result", result)
                .add("exceptions", exceptions);
        if (firstError != null) {
            obj.add("firstError", firstError);
        }
        return obj.toString();
    }

    public Map<String, Object> toMap() {
        Map<String, Object> map = new HashMap<>();
        map.put("name", name);
        // TODO: fix tags defined by test tools
//        map.put("tags", tags);
        map.put("timestamp", timestamp);
        map.put("duration", duration);
        map.put("right", right);
        map.put("wrong", wrong);
        map.put("result", result);
        map.put("exceptions", exceptions);
        if (firstError != null) {
            map.put("firstError", firstError);
        }
        return map;
    }
}
