/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.fitnesse;

import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.EventHandler;
import com.xebialabs.xltest.domain.ImportException;
import com.xebialabs.xltest.domain.ImportFailedException;
import com.xebialabs.xltest.domain.Importable;
import com.xebialabs.xltest.fitnesse.TestSummary;
import com.xebialabs.xltest.importers.ImporterUtil;
import fitnesse.reporting.history.ExecutionReport;
import fitnesse.reporting.history.PageHistory;
import fitnesse.reporting.history.SuiteExecutionReport;
import fitnesse.reporting.history.TestExecutionReport;
import fitnesse.reporting.history.TestHistory;
import fitnesse.reporting.history.TestResultRecord;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.SystemVariableSource;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.fs.FileSystemPage;
import fitnesse.wiki.fs.FileSystemPageFactory;
import fitnesse.wikitext.parser.VariableSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.FileUtil;

public class PageHistoryExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(PageHistoryExtractor.class);
    private final File resultsDirectory;
    private final FileSystemPage root;
    private final TestHistory history = new TestHistory();

    public PageHistoryExtractor(File fitNesseRoot) {
        this.resultsDirectory = new File(fitNesseRoot, "files/testResults");
        this.root = new FileSystemPageFactory().makePage(fitNesseRoot, "FitNesseRoot", null, (VariableSource)new SystemVariableSource());
        this.history.readHistoryDirectory(this.resultsDirectory);
    }

    public List<Importable> createImportables() throws ImportFailedException {
        ArrayList<Importable> toImport = new ArrayList<Importable>();
        File[] resultFiles = this.resultsDirectory.listFiles();
        if (resultFiles == null) {
            return Collections.emptyList();
        }
        try {
            for (File pageNamedFile : resultFiles) {
                if (!pageNamedFile.isDirectory()) continue;
                String pageName = pageNamedFile.getName();
                LOG.trace("Will try to make report for " + pageName);
                PageHistory pageHistory = this.getPageHistory(this.resultsDirectory, pageName);
                if (!this.pageHistoryIsSuite(pageHistory)) continue;
                for (Date date : pageHistory.datesInChronologicalOrder()) {
                    Object executionReport = this.getExecutionReport(pageHistory, date);
                    if (!(executionReport instanceof SuiteExecutionReport)) continue;
                    toImport.add(new FitNesseSuiteImporter((SuiteExecutionReport)executionReport, pageName));
                }
            }
        }
        catch (Exception e) {
            throw new ImportFailedException((Throwable)e);
        }
        Collections.sort(toImport, new Comparator<Importable>(){

            @Override
            public int compare(Importable o1, Importable o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        return toImport;
    }

    public void produceEventsForReport(UUID testRunId, SuiteExecutionReport suiteExecutionReport, EventHandler eventHandler) throws ImportException {
        for (SuiteExecutionReport.PageHistoryReference reference : suiteExecutionReport.getPageHistoryReferences()) {
            Set<String> tags = this.findTags(reference);
            String firstErrorMessage = this.findFirstErrorMessage(reference);
            ImporterUtil.sendEvent((EventHandler)eventHandler, (UUID)testRunId, (String)"functionalResult", new TestSummary(Event.normalizeName((String)reference.getPageName(), (Character)Character.valueOf('.')), tags, reference.getTime(), (int)reference.getRunTimeInMillis(), reference.getTestSummary().getRight(), reference.getTestSummary().getWrong(), reference.getTestSummary().getWrong() + reference.getTestSummary().getExceptions() > 0 ? "FAILED" : "PASSED", reference.getTestSummary().getExceptions(), firstErrorMessage).toMap());
        }
    }

    private Set<String> findTags(SuiteExecutionReport.PageHistoryReference reference) {
        WikiPagePath wikiPagePath = PathParser.parse((String)reference.getPageName());
        PageCrawler pageCrawler = this.root.getPageCrawler();
        Set<String> tags = PageHistoryExtractor.set(new String[0]);
        if (pageCrawler.pageExists(wikiPagePath)) {
            WikiPage thePage = pageCrawler.getPage(wikiPagePath);
            tags = this.findTags(thePage);
        }
        return tags;
    }

    private Set<String> findTags(WikiPage page) {
        if (page == null || page.isRoot()) {
            return PageHistoryExtractor.set(new String[0]);
        }
        String tags = page.getData().getAttribute("Suites");
        Set<String> tagSet = this.isNotBlank(tags) ? PageHistoryExtractor.set(tags.split(",")) : PageHistoryExtractor.set(new String[0]);
        tagSet.addAll(this.findTags(page.getParent()));
        return tagSet;
    }

    private String findFirstErrorMessage(SuiteExecutionReport.PageHistoryReference reference) {
        String firstErrorMessage = null;
        try {
            TestExecutionReport testExecutionReport = (TestExecutionReport)this.getExecutionReport(this.getPageHistory(this.resultsDirectory, reference.getPageName()), new Date(reference.getTime()));
            firstErrorMessage = this.findFirstErrorMessage(testExecutionReport);
        }
        catch (Exception e) {
            LOG.warn("Unable to find test result file for test page {}", (Object)reference.getPageName());
            LOG.debug("Could not determine first error message", (Throwable)e);
        }
        return firstErrorMessage;
    }

    private String findFirstErrorMessage(TestExecutionReport testExecutionReport) {
        TestExecutionReport.TestResult testResult = (TestExecutionReport.TestResult)testExecutionReport.getResults().get(0);
        for (TestExecutionReport.InstructionResult instructionResult : testResult.getInstructions()) {
            for (TestExecutionReport.Expectation expectation : instructionResult.getExpectations()) {
                if ("fail".equals(expectation.getStatus())) {
                    return String.format("Actual: '%s'; Expected: '%s'", expectation.getActual(), expectation.getExpected());
                }
                if (!"error".equals(expectation.getStatus())) continue;
                return expectation.getEvaluationMessage();
            }
        }
        return null;
    }

    private <T extends ExecutionReport> T getExecutionReport(PageHistory pageHistory, Date date) throws Exception {
        TestResultRecord testResultRecord = pageHistory.get(date);
        return (T)ExecutionReport.makeReport((String)FileUtil.getFileContent((File)testResultRecord.getFile()));
    }

    private PageHistory getPageHistory(File resultsDirectory, String pageName) throws FileNotFoundException {
        if (!resultsDirectory.canRead()) {
            throw new FileNotFoundException("Could not find " + resultsDirectory);
        }
        return this.history.getPageHistory(pageName);
    }

    private boolean pageHistoryIsSuite(PageHistory pageHistory) throws Exception {
        if (pageHistory == null) {
            return false;
        }
        Object report = this.getExecutionReport(pageHistory, pageHistory.getLatestDate());
        return report instanceof SuiteExecutionReport;
    }

    public static Set<String> set(String ... tags) {
        TreeSet<String> tagSet = new TreeSet<String>();
        for (String tag : tags) {
            String trimmed = tag.trim();
            if ("".equals(trimmed)) continue;
            tagSet.add(trimmed);
        }
        return tagSet;
    }

    private boolean isNotBlank(String tags) {
        return tags != null && !"".equals(tags);
    }

    public class FitNesseSuiteImporter
    implements Importable {
        private final SuiteExecutionReport executionReport;
        private final String pageName;

        public FitNesseSuiteImporter(SuiteExecutionReport executionReport, String pageName) {
            this.executionReport = executionReport;
            this.pageName = pageName;
        }

        public long getTimestamp() {
            return this.executionReport.getDate().getTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doImport(UUID testRunId, EventHandler eventHandler) throws ImportException {
            LOG.debug("doImport({},{})", (Object)testRunId, (Object)eventHandler);
            ImporterUtil.sendEvent((EventHandler)eventHandler, (UUID)testRunId, (String)"importStarted", (Map)Event.props((Object[])new Object[]{"fileName", this.pageName, "lastModified", this.executionReport.getDate().getTime(), "suiteName", this.executionReport.getRootPath()}));
            try {
                PageHistoryExtractor.this.produceEventsForReport(testRunId, this.executionReport, eventHandler);
            }
            catch (Throwable throwable) {
                int duration = (int)this.executionReport.getTotalRunTimeInMillis();
                ImporterUtil.sendEvent((EventHandler)eventHandler, (UUID)testRunId, (String)"importFinished", (Map)Event.props((Object[])new Object[]{"duration", duration}));
                throw throwable;
            }
            int duration = (int)this.executionReport.getTotalRunTimeInMillis();
            ImporterUtil.sendEvent((EventHandler)eventHandler, (UUID)testRunId, (String)"importFinished", (Map)Event.props((Object[])new Object[]{"duration", duration}));
        }
    }
}

