package com.xebialabs.xltest.jmeter;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.domain.BaseTestTool;
import com.xebialabs.xltest.domain.Importable;
import com.xebialabs.xltest.utils.TestToolCategory;
import com.xebialabs.xltest.utils.glob.FileMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JMeterTestTool extends BaseTestTool {

    private static final Logger LOG = LoggerFactory.getLogger(JMeterTestTool.class);

    @Override
    public String getName() {
        return "JMeter";
    }

    @Override
    public List<Importable> findImportables(final OverthereFile searchPath, final FileMatcher fileMatcher) throws JMeterNoImportableResultsException {
        Collection<OverthereFile> testResultFiles = globFiles(searchPath, fileMatcher);

        List<Importable> importables = new ArrayList<>();
        for (OverthereFile testResult : testResultFiles) {
            String name = testResult.getName();
            if (name.endsWith(".csv") || name.endsWith("*.txt")) {
                importables.add(new JMeterCsvImporter(testResult));
            } else if (name.endsWith(".xml")) {
                importables.add(new JMeterXmlImporter(testResult));
            } else {
                LOG.warn("Unable to import {} because it does not end with .csv, .txt or .xml - will skip importing this file!", name);
            }
        }
        if (importables.isEmpty()) {
            throw new JMeterNoImportableResultsException(String.format("No importable results found in '%s' with matcher '%s'", searchPath, fileMatcher));
        }
        return importables;
    }

    @Override
    public String getCategory() {
        return TestToolCategory.PERFORMANCE;
    }

    @Override
    public String getDefaultSearchPattern() {
        return "**/summary.csv";
    }

}
