/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.jmeter;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.domain.BaseTestTool;
import com.xebialabs.xltest.domain.Importable;
import com.xebialabs.xltest.jmeter.JMeterCsvImporter;
import com.xebialabs.xltest.jmeter.JMeterNoImportableResultsException;
import com.xebialabs.xltest.jmeter.JMeterXmlImporter;
import com.xebialabs.xltest.utils.glob.FileMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMeterTestTool
extends BaseTestTool {
    private static final Logger LOG = LoggerFactory.getLogger(JMeterTestTool.class);

    public String getName() {
        return "JMeter";
    }

    public List<Importable> findImportables(OverthereFile searchPath, FileMatcher fileMatcher) throws JMeterNoImportableResultsException {
        SortedSet testResultFiles = this.globFiles(searchPath, fileMatcher);
        ArrayList<Importable> importables = new ArrayList<Importable>();
        for (OverthereFile testResult : testResultFiles) {
            String name = testResult.getName();
            if (name.endsWith(".csv") || name.endsWith("*.txt")) {
                importables.add((Importable)new JMeterCsvImporter(testResult));
                continue;
            }
            if (name.endsWith(".xml")) {
                importables.add((Importable)new JMeterXmlImporter(testResult));
                continue;
            }
            LOG.warn("Unable to import {} because it does not end with .csv, .txt or .xml - will skip importing this file!", (Object)name);
        }
        if (importables.isEmpty()) {
            throw new JMeterNoImportableResultsException(String.format("No importable results found in '%s' with matcher '%s'", searchPath, fileMatcher));
        }
        return importables;
    }

    public String getCategory() {
        return "performance";
    }

    public String getDefaultSearchPattern() {
        return "**/summary.csv";
    }
}

