package com.xebialabs.xltest;

import java.util.EnumSet;
import javax.servlet.DispatcherType;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.jboss.resteasy.plugins.spring.SpringContextLoaderListener;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;


public class XLTest {

    private Server server;
    private static final String SPRING_CTX_CFG_LOCATION_KEY = "contextConfigLocation";
    private static final String SPRING_CONFIG = "classpath:spring/xltest-context.xml";

    public void startWebApp() throws Exception {
        org.eclipse.jetty.util.thread.QueuedThreadPool threadPool = new org.eclipse.jetty.util.thread.QueuedThreadPool();
        threadPool.setMinThreads(10);
        threadPool.setMaxThreads(1000);
        server = new Server(threadPool);

        ServerConnector connector = new ServerConnector(server);
        connector.setPort(webAppPortNumber());
        connector.setHost(webAppBindAddress());
        server.setConnectors(new Connector[]{connector});

        server.setHandler(createWebAppContext());

        server.start();



        server.setStopAtShutdown(true);
    }

    private String webAppBindAddress() {
        return System.getProperty("xltest.host", "0.0.0.0");
    }

    public int webAppPortNumber() {
        return Integer.getInteger("xltest.port", 6516);
    }

    public void stopWebApp() throws Exception {
        server.stop();
        server.join();
    }

    private WebAppContext createWebAppContext() {
        WebAppContext context = new WebAppContext();

        context.setContextPath("");
        context.setInitParameter("contextConfigLocation", ContextConfig.class.getName());
        context.setInitParameter("contextClass", AnnotationConfigWebApplicationContext.class.getName());
        context.addEventListener(new ResteasyBootstrap());
        context.addEventListener(new SpringContextLoaderListener()); // was: DeployitSpringContextLoaderListener

        ServletHolder servletHolder = new ServletHolder(HttpServletDispatcher.class);
        context.getInitParams().put("resteasy.servlet.mapping.prefix", "/");
        context.getInitParams().put("resteasy.document.expand.entity.references", "false");
        context.addServlet(servletHolder, "/*");
        context.setResourceBase(".");


        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        context.addFilter(filter, "/*", EnumSet.of(DispatcherType.REQUEST));
        // no persistency yet DefaultStorageProvider.setInstance(new Mime4jStorageProvider());

        return context;
    }

}
