package com.xebialabs.xltest.serialize;

import java.util.Map;
import java.util.Set;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONWriter;
import org.springframework.stereotype.Component;

import com.xebialabs.xltest.view.ExecutionParameterRequest;

@Component
@Provider
@Produces({MediaType.APPLICATION_JSON})
public class ExecutionParameterRequestWriter extends BasicMessageBodyWriter<ExecutionParameterRequest> {

    @Override
    protected void writeJson(ExecutionParameterRequest executionParameterRequest, JSONWriter writer) throws JSONException {
        writer.object();
        writer.key("hostId").value(executionParameterRequest.getHostId());
        writer.key("commandLine").value(executionParameterRequest.getCommandLine());
        writer.key("parameters");
        writer.array();
        for (Map.Entry<String, Set<String>> parameter : executionParameterRequest.getParameters().entrySet()) {
            writeJson(parameter.getKey(), parameter.getValue(), writer);
        }
        writer.endArray();

        writer.endObject();
    }

    private void writeJson(String name, Set<String> values, JSONWriter writer) throws JSONException {
        writer.object();
        writer.key("name").value(name);
        writer.key("values");
        writer.array();
        for (String eachValue : values) {
            writer.value(eachValue);
        }
        writer.endArray();
        writer.key("value").value(getValue(values));
        writer.endObject();
    }

    public String getValue(Set<String> values) {
        return values.size() == 1 ? values.iterator().next() : "";
    }
}
