package com.xebialabs.xltest.serialize.metadata;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;
import com.google.common.annotations.VisibleForTesting;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.xltype.serialization.json.JsonWriter;

@Component
@Provider
@Produces({MediaType.APPLICATION_JSON})
public class DescriptorsJsonWriter implements MessageBodyWriter<Collection<Descriptor>> {

    @Override
    public boolean isWriteable(Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType) {
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            type = (Class<?>) ((ParameterizedType) genericType).getActualTypeArguments()[0];
        }
        return Descriptor.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(final Collection<Descriptor> descriptors, final Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(final Collection<Descriptor> descriptors, final Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType, final MultivaluedMap<String, Object> httpHeaders, final OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(toJson(descriptors).getBytes());
    }

    @VisibleForTesting
    String toJson(Collection<Descriptor> descriptors) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter(stringWriter);
        writer.array();

        for (Descriptor descriptor : descriptors) {
            new DescriptorJsonWriter().writeJson(descriptor, writer);
        }

        writer.endArray();
        return stringWriter.toString();
    }
}
