package com.xebialabs.xltest.utils.glob;

import java.util.Date;
import org.springframework.util.AntPathMatcher;
import com.google.common.base.Preconditions;

import com.xebialabs.overthere.OverthereFile;

public class FileMatcher {
    private final String pattern;

    private Date lastModifiedDateAfter;

    private AntPathMatcher pathMatcher = new AntPathMatcher();

    public FileMatcher(String pattern) {
        Preconditions.checkNotNull(pattern, "A Ant style pattern is required");
        this.pattern = pattern;
    }

    public FileMatcher withLastModifiedDateAfter(Date modifiedDate) {
        this.lastModifiedDateAfter = modifiedDate;
        return this;
    }

    public boolean match(OverthereFile file) {
        boolean matched = true;
        matched &= pathMatcher.match(pattern, file.getPath());
        if (lastModifiedDateAfter != null) {
            matched = matched && file.lastModified() > lastModifiedDateAfter.getTime();
        }
        return matched;
    }

    public boolean match(String filePath) {
        return pathMatcher.match(pattern, filePath);
    }
}
