/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.get;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.snapshots.SnapshotInfo;

public class GetSnapshotsResponse
extends ActionResponse
implements ToXContent {
    private ImmutableList<SnapshotInfo> snapshots = ImmutableList.of();

    GetSnapshotsResponse() {
    }

    GetSnapshotsResponse(ImmutableList<SnapshotInfo> snapshots) {
        this.snapshots = snapshots;
    }

    public ImmutableList<SnapshotInfo> getSnapshots() {
        return this.snapshots;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            builder.add(SnapshotInfo.readSnapshotInfo(in));
        }
        this.snapshots = builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.snapshots.size());
        for (SnapshotInfo snapshotInfo : this.snapshots) {
            snapshotInfo.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(Fields.SNAPSHOTS);
        for (SnapshotInfo snapshotInfo : this.snapshots) {
            snapshotInfo.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString SNAPSHOTS = new XContentBuilderString("snapshots");

        Fields() {
        }
    }
}

