/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.FixedBitSetCachingWrapperFilter;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.search.join.ToParentBlockJoinQuery;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.lucene.search.XConstantScoreQuery;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.NestedQueryParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;

public class NestedFilterParser
implements FilterParser {
    public static final String NAME = "nested";

    @Inject
    public NestedFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        Object query = null;
        boolean queryFound = false;
        Filter filter = null;
        boolean filterFound = false;
        float boost = 1.0f;
        boolean join = true;
        String path = null;
        boolean cache = false;
        CacheKeyFilter.Key cacheKey = null;
        String filterName = null;
        NestedQueryParser.LateBindingParentFilter currentParentFilterContext = NestedQueryParser.parentFilterContext.get();
        NestedQueryParser.LateBindingParentFilter usAsParentFilter = new NestedQueryParser.LateBindingParentFilter();
        NestedQueryParser.parentFilterContext.set(usAsParentFilter);
        try {
            Filter nestedFilter;
            Filter childFilter;
            XContentParser.Token token;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("query".equals(currentFieldName)) {
                        queryFound = true;
                        query = parseContext.parseInnerQuery();
                        continue;
                    }
                    if ("filter".equals(currentFieldName)) {
                        filterFound = true;
                        filter = parseContext.parseInnerFilter();
                        continue;
                    }
                    throw new QueryParsingException(parseContext.index(), "[nested] filter does not support [" + currentFieldName + "]");
                }
                if (!token.isValue()) continue;
                if ("join".equals(currentFieldName)) {
                    join = parser.booleanValue();
                    continue;
                }
                if ("path".equals(currentFieldName)) {
                    path = parser.text();
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    boost = parser.floatValue();
                    continue;
                }
                if ("_scope".equals(currentFieldName)) {
                    throw new QueryParsingException(parseContext.index(), "the [_scope] support in [nested] filter has been removed, use nested filter as a facet_filter in the relevant facet");
                }
                if ("_name".equals(currentFieldName)) {
                    filterName = parser.text();
                    continue;
                }
                if ("_cache".equals(currentFieldName)) {
                    cache = parser.booleanValue();
                    continue;
                }
                if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                    cacheKey = new CacheKeyFilter.Key(parser.text());
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[nested] filter does not support [" + currentFieldName + "]");
            }
            if (!queryFound && !filterFound) {
                throw new QueryParsingException(parseContext.index(), "[nested] requires either 'query' or 'filter' field");
            }
            if (path == null) {
                throw new QueryParsingException(parseContext.index(), "[nested] requires 'path' field");
            }
            if (query == null && filter == null) {
                Filter filter2 = null;
                return filter2;
            }
            if (filter != null) {
                query = new XConstantScoreQuery(filter);
            }
            query.setBoost(boost);
            MapperService.SmartNameObjectMapper mapper = parseContext.smartObjectMapper(path);
            if (mapper == null) {
                throw new QueryParsingException(parseContext.index(), "[nested] failed to find nested object under path [" + path + "]");
            }
            ObjectMapper objectMapper = mapper.mapper();
            if (objectMapper == null) {
                throw new QueryParsingException(parseContext.index(), "[nested] failed to find nested object under path [" + path + "]");
            }
            if (!objectMapper.nested().isNested()) {
                throw new QueryParsingException(parseContext.index(), "[nested] nested object under path [" + path + "] is not of nested type");
            }
            usAsParentFilter.filter = childFilter = parseContext.cacheFilter(objectMapper.nestedTypeFilter(), null);
            query = new XFilteredQuery((Query)query, childFilter);
            Filter parentFilter = currentParentFilterContext;
            if (parentFilter == null) {
                parentFilter = NonNestedDocsFilter.INSTANCE;
                parentFilter = parseContext.cacheFilter(parentFilter, null);
            }
            parentFilter = new FixedBitSetCachingWrapperFilter(parentFilter);
            if (join) {
                ToParentBlockJoinQuery joinQuery = new ToParentBlockJoinQuery((Query)query, parentFilter, ScoreMode.None);
                nestedFilter = Queries.wrap((Query)joinQuery);
            } else {
                nestedFilter = Queries.wrap((Query)query);
            }
            if (cache) {
                nestedFilter = parseContext.cacheFilter(nestedFilter, cacheKey);
            }
            if (filterName != null) {
                parseContext.addNamedFilter(filterName, nestedFilter);
            }
            Filter filter3 = nestedFilter;
            return filter3;
        }
        finally {
            NestedQueryParser.parentFilterContext.set(currentParentFilterContext);
        }
    }
}

