/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class WrapperQueryParser
implements QueryParser {
    public static final String NAME = "wrapper";

    @Inject
    public WrapperQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new QueryParsingException(parseContext.index(), "[wrapper] query malformed");
        }
        String fieldName = parser.currentName();
        if (!fieldName.equals("query")) {
            throw new QueryParsingException(parseContext.index(), "[wrapper] query malformed");
        }
        parser.nextToken();
        byte[] querySource = parser.binaryValue();
        try (XContentParser qSourceParser = XContentFactory.xContent(querySource).createParser(querySource);){
            QueryParseContext context = new QueryParseContext(parseContext.index(), parseContext.indexQueryParser);
            context.reset(qSourceParser);
            Query result = context.parseInnerQuery();
            parser.nextToken();
            Query query = result;
            return query;
        }
    }
}

