/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.authentication.SecureWriteOperation;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.editing.MergeResponder;
import fitnesse.responders.editing.SaveRecorder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageUtil;

public class SaveResponder
implements SecureResponder {
    private String user;
    private long ticketId;
    private String savedContent;
    private String helpText;
    private String suites;
    private WikiPage page;
    private PageData data;
    private long editTimeStamp;

    @Override
    public Response makeResponse(FitNesseContext context, Request request) {
        this.editTimeStamp = this.getEditTime(request);
        this.ticketId = this.getTicketId(request);
        String resource = request.getResource();
        this.page = this.getPage(resource, context);
        this.data = this.page.getData();
        this.user = request.getAuthorizationUsername();
        if (this.editsNeedMerge()) {
            return new MergeResponder(request).makeResponse(context, request);
        }
        this.savedContent = (String)request.getInput("pageContent");
        this.helpText = (String)request.getInput("helpText");
        this.suites = (String)request.getInput("suites");
        return this.saveEdits(context, request, this.page);
    }

    private Response saveEdits(FitNesseContext context, Request request, WikiPage page) {
        SimpleResponse response = new SimpleResponse();
        this.setData();
        VersionInfo commitRecord = page.commit(this.data);
        if (commitRecord != null) {
            response.addHeader("Current-Version", commitRecord.getName());
        }
        context.recentChanges.updateRecentChanges(page);
        if (request.hasInput("redirect")) {
            response.redirect("", request.getInput("redirect").toString());
        } else {
            response.redirect(context.contextRoot, request.getResource());
        }
        return response;
    }

    private boolean editsNeedMerge() {
        return SaveRecorder.changesShouldBeMerged(this.editTimeStamp, this.ticketId, this.page);
    }

    private long getTicketId(Request request) {
        if (!request.hasInput("ticketId")) {
            return 0L;
        }
        String ticketIdString = (String)request.getInput("ticketId");
        return Long.parseLong(ticketIdString);
    }

    private long getEditTime(Request request) {
        if (!request.hasInput("editTime")) {
            return 0L;
        }
        String editTimeStampString = (String)request.getInput("editTime");
        return Long.parseLong(editTimeStampString);
    }

    private WikiPage getPage(String resource, FitNesseContext context) {
        WikiPagePath path = PathParser.parse(resource);
        PageCrawler pageCrawler = context.root.getPageCrawler();
        WikiPage page = pageCrawler.getPage(path);
        if (page == null) {
            page = WikiPageUtil.addPage(context.root, PathParser.parse(resource));
        }
        return page;
    }

    private void setData() {
        this.data.setContent(this.savedContent);
        this.data.setOrRemoveAttribute("Help", this.helpText);
        this.data.setOrRemoveAttribute("Suites", this.suites);
        SaveRecorder.pageSaved(this.page, this.ticketId);
        this.data.setOrRemoveAttribute("LastModifyingUser", this.user);
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureWriteOperation();
    }
}

