package com.xebialabs.xltest.domain;

import java.util.Collection;
import java.util.List;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.utils.glob.FileMatcher;

public interface TestTool {

    /**
     * Provide a decent (human readable) name for the test tool
     *
     * @return the name.
     */
    String getName();

    String getCategory();

    /**
     * Default search pattern used to lookfor result files. If <code>null</code> is returned,
     * search pattern is not supported.
     *
     * @return Oh my!
     */
    String getSearchPattern();

    /**
     * Get a set of files matching the search qualification. This are the files that
     * will be imported or the directories that will be imported from.
     *
     * @param searchRoot
     * @param fileMatcher An Ant-like search pattern, e.g. <code>**\/*.xml</code>
     * @return yup.
     */
    Collection<OverthereFile> findTestResultPaths(OverthereFile searchRoot, FileMatcher fileMatcher);

    /**
     * Construct a list of "workers" that can take care of importing a test run. Each importable
     * represents a separate test run.
     *
     * @param testResultPath
     * @param fileMatcher
     * @return a list of objects that can be instructed to perform the import.
     */
    List<Importable> findImportables(OverthereFile testResultPath, FileMatcher fileMatcher);
}
