package com.xebialabs.xltest.resources;

import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.repository.TestRunsRepository;
import com.xebialabs.xltest.view.ExecutionParameters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.io.IOException;
import java.util.Map;


@Controller
@Path("/rerun")
@Produces(MediaType.APPLICATION_JSON)
@Consumes(MediaType.APPLICATION_JSON)
public class RerunController {
    private final TestRunsRepository testRunsRepository;
    private final ExecuteController executeController;

    @Autowired
    public RerunController(TestRunsRepository testRunsRepository, ExecuteController executeController) {
        this.testRunsRepository = testRunsRepository;
        this.executeController = executeController;
    }


    @GET
    @Path("/{runId}/{suite}")
    public Response rerun(@PathParam("runId") String runId, @PathParam("suite") String suite) throws IOException, InterruptedException {
        TestRun testRun = testRunsRepository.getTestRun(runId);
        String testSpecificationName = testRun.getTestSpecificationName();
        ExecutionParameters executionParameters = new ExecutionParameters(testRun.getParameters());
        Map<String, Object> parameters = executionParameters.getParameters();
        parameters.put("suiteName", suite);
        return executeController.execute(testSpecificationName, executionParameters);
    }

}

