/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.resources;

import com.jayway.jsonpath.spi.JsonProviderFactory;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.Report;
import com.xebialabs.xltest.domain.TestSpecification;
import com.xebialabs.xltest.service.EventRepository;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/migrate")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class MigrationController {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationController.class);
    private static final String[] propsToCopy = new String[]{"branch", "browser", "environment", "repositoryUrl", "suiteFilter", "suiteName", "webdriver"};
    private final EventRepository eventRepository;
    private final RepositoryService repository;
    private static boolean alreadyMigrated = false;
    private long totalInsertedEvents = 0L;

    @Autowired
    public MigrationController(EventRepository eventRepository, RepositoryService repository) {
        this.eventRepository = eventRepository;
        this.repository = repository;
    }

    @GET
    @Path(value="/")
    public Response migrate(@Context UriInfo uriInfo) throws IOException {
        String feedback = "";
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        String host = null;
        if (queryParameters.get((Object)"host") != null) {
            host = (String)((List)queryParameters.get((Object)"host")).get(0);
        }
        String port = null;
        if (queryParameters.get((Object)"port") != null) {
            port = (String)((List)queryParameters.get((Object)"port")).get(0);
        }
        if (host != null && port != null && !alreadyMigrated) {
            URL oldBaseUrl = new URL("http://" + host + ":" + port);
            if (this.checkMigratable(oldBaseUrl)) {
                LOG.info("migration started");
                alreadyMigrated = true;
                this.migrateJCRReports();
                feedback = this.migrateES(oldBaseUrl);
            } else {
                feedback = "Sorry, can't migrate as I can't reach your old ElasticSearch on host " + host + " and port " + port;
            }
        } else {
            feedback = alreadyMigrated ? "Sorry, can't migrate. It seems you already did. Restart server when in doubt" : "Sorry, can't migrate. I expected two query parameters: host=<hostname> and port=<portnumber>";
        }
        return Response.ok((Object)feedback).build();
    }

    private void migrateJCRReports() {
        Report compositePerTeam = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"xltest.CompositeReport")).newInstance("");
        compositePerTeam.setId("Configuration/Reports/CompositePerTeam");
        compositePerTeam.setProperty("title", "Test Results per team");
        compositePerTeam.setProperty("scriptLocation", "reports/CompositeReport.py");
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{compositePerTeam});
        Report bar = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"xltest.GraphReport")).newInstance("");
        bar.setId("Configuration/Reports/barchart");
        bar.setProperty("scriptLocation", "reports/GraphReport.py");
        bar.setProperty("drilldownsequence", "team, application, applicationPackage, usecase, testcase");
        bar.setProperty("drilldown", compositePerTeam);
        bar.setProperty("useTeamInDrillDown", true);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{bar});
        Report pie = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"xltest.PieReport")).newInstance("");
        pie.setId("Configuration/Reports/pie");
        pie.setProperty("scriptLocation", "reports/PieReport.py");
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{pie});
        Report details = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"bol.FreemarkerReportWithHistory")).newInstance("");
        details.setId("Configuration/Reports/drilldown");
        details.setProperty("scriptLocation", "reports/drilldowndetails.ftl");
        details.setProperty("reportType", "html");
        details.setProperty("maxRunsInHistory", 10);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{details});
        compositePerTeam.setProperty("topLeft", bar);
        compositePerTeam.setProperty("topRight", pie);
        compositePerTeam.setProperty("bottom", details);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{compositePerTeam});
        Report compositePerApp = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"xltest.CompositeReport")).newInstance("");
        compositePerApp.setId("Configuration/Reports/CompositePerApp");
        compositePerApp.setProperty("title", "Test Results");
        compositePerApp.setProperty("scriptLocation", "reports/CompositeReport.py");
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{compositePerApp});
        Report barchartPerApp = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"xltest.GraphReport")).newInstance("");
        barchartPerApp.setId("Configuration/Reports/barchartPerApp");
        barchartPerApp.setProperty("scriptLocation", "reports/GraphReport.py");
        barchartPerApp.setProperty("drilldownsequence", "application, applicationPackage, usecase, testcase");
        barchartPerApp.setProperty("drilldown", compositePerApp);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{barchartPerApp});
        compositePerApp.setProperty("topLeft", barchartPerApp);
        compositePerApp.setProperty("topRight", pie);
        compositePerApp.setProperty("bottom", details);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{compositePerApp});
        Report monitor = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"xltest.CompositeReport")).newInstance("");
        monitor.setId("Configuration/Reports/monitor");
        monitor.setProperty("title", "Test Automation Results");
        monitor.setProperty("scriptLocation", "reports/CompositeReport.py");
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{monitor});
        Report monitorApp = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"xltest.CompositeReport")).newInstance("");
        monitorApp.setId("Configuration/Reports/monitorApp");
        monitorApp.setProperty("title", "Test Automation Results Per App");
        monitorApp.setProperty("scriptLocation", "reports/CompositeReport.py");
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{monitorApp});
        Report monitorChart = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"xltest.GraphReport")).newInstance("");
        monitorChart.setId("Configuration/Reports/Monitor chart");
        monitorChart.setProperty("scriptLocation", "reports/DashboardReport.py");
        monitorChart.setProperty("drilldownsequence", "team, application, applicationPackage, usecase");
        monitorChart.setProperty("drilldown", monitor);
        monitorChart.setProperty("useTeamInDrillDown", true);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{monitorChart});
        Report monitorAppChart = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"xltest.GraphReport")).newInstance("");
        monitorAppChart.setId("Configuration/Reports/Monitor APP chart");
        monitorAppChart.setProperty("scriptLocation", "reports/DashboardReport.py");
        monitorAppChart.setProperty("drilldownsequence", "team, application, usecase, testcase");
        monitorAppChart.setProperty("drilldown", monitorApp);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{monitorAppChart});
        Report monitorPie = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"xltest.GraphReport")).newInstance("");
        monitorPie.setId("Configuration/Reports/Monitor pie chart");
        monitorPie.setProperty("scriptLocation", "reports/DashboardPieReport.py");
        monitorPie.setProperty("drilldownsequence", "team, application, applicationPackage, usecase, testcase");
        monitorPie.setProperty("drilldown", monitor);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{monitorPie});
        Report monitorNavigation = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"bol.FreemarkerReportWithHistory")).newInstance("");
        monitorNavigation.setId("Configuration/Reports/Monitor navigation chart");
        monitorNavigation.setProperty("scriptLocation", "reports/monitorBottom.ftl");
        monitorNavigation.setProperty("reportType", "html");
        monitorNavigation.setProperty("maxRunsInHistory", 10);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{monitorNavigation});
        Report monitorAppNavigation = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"bol.FreemarkerReportWithHistory")).newInstance("");
        monitorAppNavigation.setId("Configuration/Reports/Monitor APP navigation chart");
        monitorAppNavigation.setProperty("scriptLocation", "reports/monitorBottomApp.ftl");
        monitorAppNavigation.setProperty("reportType", "html");
        monitorAppNavigation.setProperty("maxRunsInHistory", 10);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{monitorAppNavigation});
        monitor.setProperty("topLeft", monitorChart);
        monitor.setProperty("topRight", monitorPie);
        monitor.setProperty("bottom", monitorNavigation);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{monitor});
        monitorApp.setProperty("topLeft", monitorAppChart);
        monitorApp.setProperty("topRight", monitorPie);
        monitorApp.setProperty("bottom", monitorAppNavigation);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{monitorApp});
        Report jobsPerSlave = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"freemarker.Report")).newInstance("");
        jobsPerSlave.setId("Configuration/Reports/jobsPerSlave");
        jobsPerSlave.setProperty("scriptLocation", "reports/jobsPerSlave.ftl");
        jobsPerSlave.setProperty("reportType", "html");
        jobsPerSlave.setProperty("iconName", "none");
        jobsPerSlave.setProperty("userFriendlyDescription", "Jobs per slave report");
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{jobsPerSlave});
        Report freemarkerDuration = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"bol.FreemarkerReportWithHistory")).newInstance("");
        freemarkerDuration.setId("Configuration/Reports/BolDuration");
        freemarkerDuration.setProperty("scriptLocation", "reports/durationdetails.ftl");
        freemarkerDuration.setProperty("reportType", "html");
        freemarkerDuration.setProperty("iconName", "none");
        freemarkerDuration.setProperty("userFriendlyDescription", "Tabular duration report");
        freemarkerDuration.setProperty("maxRunsInHistory", 20);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{freemarkerDuration});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkMigratable(URL oldBaseUrl) {
        block7: {
            HttpURLConnection connToOldES = null;
            try {
                URL oldMappingUrl = new URL(oldBaseUrl, "xltest/_mapping");
                connToOldES = (HttpURLConnection)oldMappingUrl.openConnection();
                int responseCodeOnOldMappingUrl = connToOldES.getResponseCode();
                LOG.info("Connected to old ESs. Resp. code on old: " + responseCodeOnOldMappingUrl);
                if (responseCodeOnOldMappingUrl == 200) {
                    break block7;
                }
                LOG.error("Could not connect to one or both ES instances, see above.....");
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                if (connToOldES != null) {
                    connToOldES.disconnect();
                }
            }
        }
        LOG.info("Found old ES so we have a migratable situation");
        return true;
    }

    private String migrateES(URL oldBaseUrl) throws IOException {
        long now = System.currentTimeMillis();
        this.migrateRuns(oldBaseUrl);
        long durationInMillis = System.currentTimeMillis() - now;
        long durationInSec = durationInMillis / 1000L;
        long durationInMin = durationInSec / 60L;
        long durationInHrs = durationInMin / 60L;
        durationInSec = durationInSec - durationInHrs * 60L * 60L - (durationInMin -= durationInHrs * 60L) * 60L;
        String feedback = "Migration done in " + durationInHrs + " hrs " + durationInMin + " min " + durationInSec + " sec, and there were " + this.totalInsertedEvents + " events found.";
        LOG.info(feedback);
        return feedback;
    }

    private void migrateRuns(URL oldBaseUrl) throws IOException {
        List<Event> startTestRunEvents = this.getStartOrFinishTestRunEvents(oldBaseUrl, "startTestRun");
        LOG.info("I found " + startTestRunEvents.size() + " start events");
        for (Event startTestRunEvent : startTestRunEvents) {
            long oldInserted = this.totalInsertedEvents;
            LOG.info("Searching events for test run {}", (Object)startTestRunEvent.getTestRunId());
            String runId = (String)startTestRunEvent.get("runId");
            List<Event> jobStatusEvents = this.getEventsPerRunId(oldBaseUrl, "jobStatus", runId);
            Event toInsertStartEvent = startTestRunEvent;
            if (!jobStatusEvents.isEmpty()) {
                HashMap otherProperties = new HashMap();
                otherProperties.putAll(jobStatusEvents.get(0).getProperties());
                otherProperties.putAll(startTestRunEvent.getProperties());
                toInsertStartEvent = new Event("executionStarted", otherProperties);
            }
            this.insertEvent(toInsertStartEvent);
            this.insertEvents(jobStatusEvents);
            this.migrateResults(oldBaseUrl, toInsertStartEvent.getTestRunId(), (String)toInsertStartEvent.get("testSpecification"));
            this.insertCorrespondingImportEvent(toInsertStartEvent);
            List<Event> finishTestRunEvents = this.getEventsPerRunId(oldBaseUrl, "finishTestRun", runId);
            Event toInsertFinishEvent = null;
            if (finishTestRunEvents.isEmpty()) {
                LOG.info("No finish event. Will generate one.");
                toInsertFinishEvent = this.compensateMissingFinishedEvent(runId, jobStatusEvents);
            } else if (!jobStatusEvents.isEmpty()) {
                HashMap otherProperties = new HashMap();
                otherProperties.putAll(jobStatusEvents.get(0).getProperties());
                otherProperties.putAll(finishTestRunEvents.get(0).getProperties());
                toInsertFinishEvent = new Event("executionFinished", otherProperties);
            }
            if (toInsertFinishEvent != null) {
                this.insertEvent(toInsertFinishEvent);
            } else {
                LOG.warn("Was not able to produce a finishedExecution event for {}", (Object)startTestRunEvent.getTestRunId());
            }
            LOG.info("Inserted {} events for run {}", (Object)(this.totalInsertedEvents - oldInserted), (Object)startTestRunEvent.getTestRunId());
        }
    }

    private void insertCorrespondingImportEvent(Event startEvent) {
        HashMap<String, Object> otherProperties = new HashMap<String, Object>();
        otherProperties.put("runId", startEvent.get("runId"));
        otherProperties.put("timestamp", startEvent.get("timestamp"));
        otherProperties.put("lastModified", startEvent.get("timestamp"));
        otherProperties.put("testSpecification", startEvent.get("testSpecification"));
        this.insertEvent(new Event("importStarted", otherProperties));
        this.insertEvent(new Event("importFinished", otherProperties));
    }

    private void insertEvents(List<Event> events) {
        for (Event event : events) {
            this.insertEvent(event);
        }
    }

    private void insertEvent(Event event) {
        LOG.debug("Insert new event for {} {}", (Object)event.getType(), (Object)event.getTestRunId());
        this.eventRepository.insert(event);
        ++this.totalInsertedEvents;
    }

    private Event compensateMissingFinishedEvent(String runId, List<Event> jobStatusEvents) {
        if (!jobStatusEvents.isEmpty()) {
            Event lastFinishedJobStatus = this.getLastFinishTimeEvent(jobStatusEvents);
            HashMap<String, Object> otherProperties = new HashMap<String, Object>();
            this.addParameters(otherProperties, jobStatusEvents.get(0));
            otherProperties.put("testSpecification", this.convertToSimpleName((String)lastFinishedJobStatus.get("testSpecification")));
            otherProperties.put("runId", runId);
            otherProperties.put("timestamp", lastFinishedJobStatus.get("timestamp"));
            Event compensatedFinishEvent = new Event("executionFinished", otherProperties);
            return compensatedFinishEvent;
        }
        return null;
    }

    private String convertToSimpleName(String testSpecification) {
        if (testSpecification != null && testSpecification.startsWith("Configuration/TestSetDefinitions/")) {
            return testSpecification.substring(testSpecification.lastIndexOf("/") + 1);
        }
        return testSpecification;
    }

    private Event getLastFinishTimeEvent(List<Event> list) {
        Event lastFinishTimeEvent = null;
        for (Event jobStatus : list) {
            if (lastFinishTimeEvent == null) {
                lastFinishTimeEvent = jobStatus;
                continue;
            }
            String lastFinishTimeEventFinishTime = (String)lastFinishTimeEvent.get("finishedTime");
            String jobStatusFinishTime = (String)jobStatus.get("finishedTime");
            if (lastFinishTimeEventFinishTime == null || jobStatusFinishTime == null || Long.parseLong(lastFinishTimeEventFinishTime) >= Long.parseLong(jobStatusFinishTime)) continue;
            lastFinishTimeEvent = jobStatus;
        }
        return lastFinishTimeEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> getStartOrFinishTestRunEvents(URL oldBaseUrl, String startOrFinish) throws IOException {
        ArrayList<Event> startTestRunEvents = new ArrayList<Event>();
        HttpURLConnection connToOldES = null;
        InputStream inputStream = null;
        try {
            URL oldMappingUrl = new URL(oldBaseUrl, "xltest/_search?q=type:" + startOrFinish + "&size=1000000");
            connToOldES = (HttpURLConnection)oldMappingUrl.openConnection();
            int responseCodeOnOldMappingUrl = connToOldES.getResponseCode();
            if (responseCodeOnOldMappingUrl == 200) {
                inputStream = connToOldES.getInputStream();
                JSONObject result = (JSONObject)JsonProviderFactory.createProvider().parse(inputStream);
                JSONObject hitsAsObject = (JSONObject)result.get((Object)"hits");
                JSONArray realHits = (JSONArray)hitsAsObject.get((Object)"hits");
                for (int i = 0; i < realHits.size(); ++i) {
                    JSONObject startOrFinishTestRun = (JSONObject)realHits.get(i);
                    JSONObject source = (JSONObject)startOrFinishTestRun.get((Object)"_source");
                    HashMap<String, Object> otherProperties = new HashMap<String, Object>();
                    for (String key : source.keySet()) {
                        if (key.equals("testSetId")) {
                            String convertToSimpleName = this.convertToSimpleName((String)source.get((Object)key));
                            otherProperties.put("testSpecification", convertToSimpleName);
                        }
                        if (key.equals("run_id")) {
                            otherProperties.put("runId", source.get((Object)key));
                        }
                        if (!key.equals("_ts")) continue;
                        otherProperties.put("timestamp", source.get((Object)key));
                    }
                    String modernType = "executionStarted";
                    if ("finishTestRun".equals(startOrFinish)) {
                        modernType = "executionFinished";
                    }
                    Event modernEvent = new Event(modernType, otherProperties);
                    startTestRunEvents.add(modernEvent);
                }
            } else {
                LOG.error("Could not retrieve instances of the " + startOrFinish + " type");
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
            if (connToOldES != null) {
                connToOldES.disconnect();
            }
        }
        return startTestRunEvents;
    }

    private void addParameters(Map<String, Object> properties, Event event) {
        for (int i = 0; i < propsToCopy.length; ++i) {
            if (!event.hasProperty(propsToCopy[i])) continue;
            properties.put(propsToCopy[i], event.get(propsToCopy[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> getEventsPerRunId(URL oldBaseUrl, String eventType, String testRunId) throws IOException {
        ArrayList<Event> jobStatusEvents = new ArrayList<Event>();
        HashSet<String> alreadyCreatedSpecifications = new HashSet<String>();
        HttpURLConnection connToOldES = null;
        InputStream inputStream = null;
        try {
            URL oldMappingUrl = new URL(oldBaseUrl, "xltest/_search?q=type:" + eventType + "%20AND%20run_id:\"" + testRunId + "\"&size=1000000");
            connToOldES = (HttpURLConnection)oldMappingUrl.openConnection();
            int responseCodeOnOldMappingUrl = connToOldES.getResponseCode();
            if (responseCodeOnOldMappingUrl == 200) {
                inputStream = connToOldES.getInputStream();
                JSONObject result = (JSONObject)JsonProviderFactory.createProvider().parse(inputStream);
                JSONObject hitsAsObject = (JSONObject)result.get((Object)"hits");
                JSONArray realHits = (JSONArray)hitsAsObject.get((Object)"hits");
                LOG.info("Have to process " + realHits.size() + " " + eventType + " Events");
                for (int i = 0; i < realHits.size(); ++i) {
                    String testSpecification;
                    JSONObject startOrFinishTestRun = (JSONObject)realHits.get(i);
                    JSONObject source = (JSONObject)startOrFinishTestRun.get((Object)"_source");
                    HashMap<String, Object> otherProperties = new HashMap<String, Object>((Map<String, Object>)source);
                    if (otherProperties.containsKey("testSetDefinition")) {
                        otherProperties.put("testSpecification", this.convertToSimpleName((String)source.get((Object)"testSetDefinition")));
                    } else if (otherProperties.containsKey("testSetId")) {
                        otherProperties.put("testSpecification", this.convertToSimpleName((String)source.get((Object)"testSetId")));
                    }
                    if (otherProperties.containsKey("run_id")) {
                        otherProperties.put("runId", source.get((Object)"run_id"));
                    }
                    otherProperties.put("timestamp", source.get((Object)"_ts"));
                    if (otherProperties.containsKey("status") && otherProperties.get("status").equals("finished")) {
                        Number started = (Number)source.get((Object)"started");
                        long duration = 0L;
                        if (started != null && source.get((Object)"_ts") != null) {
                            duration = ((Number)source.get((Object)"_ts")).longValue() - started.longValue();
                        }
                        otherProperties.put("started", started);
                        otherProperties.put("duration", duration);
                        otherProperties.put("result", source.get((Object)"reason"));
                    }
                    if (otherProperties.containsKey("testset")) {
                        otherProperties.put("name", this.semicolonSeparate((String)source.get((Object)"testset")));
                    }
                    Event jobStatusEvent = new Event(eventType, otherProperties);
                    if ("jobStatus".equals(eventType) && jobStatusEvent.hasProperty("testSpecification") && !alreadyCreatedSpecifications.contains(testSpecification = (String)jobStatusEvent.get("testSpecification"))) {
                        Host host = null;
                        if (jobStatusEvent.hasProperty("jenkinsUri") && jobStatusEvent.hasProperty("jobName")) {
                            host = this.createJenkinsHostInJcr((String)jobStatusEvent.get("jenkinsUri"), testSpecification, (String)jobStatusEvent.get("jobName"));
                        }
                        this.createTestSpecificationInJcr(testSpecification, host);
                        alreadyCreatedSpecifications.add(testSpecification);
                    }
                    jobStatusEvents.add(jobStatusEvent);
                }
            } else {
                LOG.error("Could not retrieve instances of the jobStatus type");
            }
        }
        finally {
            if (connToOldES != null) {
                connToOldES.disconnect();
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return jobStatusEvents;
    }

    private Host createJenkinsHostInJcr(String jenkinsUri, String testSpecification, String jobName) {
        Host host = (Host)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"overthere.JenkinsHost")).newInstance("");
        host.setId("Infrastructure/" + testSpecification + " Host");
        host.setProperty("address", (Object)jenkinsUri);
        host.setProperty("jobName", (Object)jobName);
        this.repository.createOrUpdate((ConfigurationItem[])new Host[]{host});
        LOG.info("New jenkins host created in JCR " + host.getId());
        return host;
    }

    private void createTestSpecificationInJcr(String testSpecificationName, Host host) {
        TestSpecification ts = (TestSpecification)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"bol.SlicedFitNesse")).newInstance("");
        ts.setId("Configuration/TestSpecifications/" + testSpecificationName);
        ts.setTestToolName("FitNesse");
        ts.setSearchPattern("**");
        ts.setWorkingDirectory(".");
        ts.setProperty("importTestResults", false);
        ts.setProperty("commandLine", "-");
        ts.setProperty("timeout", 0);
        if (host != null) {
            ts.setHost(host);
        }
        this.repository.createOrUpdate((ConfigurationItem[])new TestSpecification[]{ts});
        LOG.info("New test specification created in JCR " + ts.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int migrateResults(URL oldBaseUrl, UUID testRunId, String testSpecification) {
        HttpURLConnection connToOldES = null;
        InputStream inputStream = null;
        int cnt = 0;
        try {
            URL oldMappingUrl = new URL(oldBaseUrl, "xltest/_search?q=type:result%20AND%20run_id:\"" + testRunId.toString() + "\"&size=1000000");
            connToOldES = (HttpURLConnection)oldMappingUrl.openConnection();
            int responseCodeOnOldMappingUrl = connToOldES.getResponseCode();
            if (responseCodeOnOldMappingUrl == 200) {
                inputStream = connToOldES.getInputStream();
                JSONObject result = (JSONObject)JsonProviderFactory.createProvider().parse(inputStream);
                JSONObject hitsAsObject = (JSONObject)result.get((Object)"hits");
                JSONArray realHits = (JSONArray)hitsAsObject.get((Object)"hits");
                LOG.info("Have to process " + realHits.size() + " Result Events");
                for (int i = 0; i < realHits.size(); ++i) {
                    JSONObject resultEvent = (JSONObject)realHits.get(i);
                    JSONObject source = (JSONObject)resultEvent.get((Object)"_source");
                    HashMap<String, Object> otherProperties = new HashMap<String, Object>((Map<String, Object>)source);
                    if (otherProperties.containsKey("run_id")) {
                        otherProperties.put("runId", source.get((Object)"run_id"));
                        otherProperties.remove("run_id");
                    }
                    if (otherProperties.containsKey("testset")) {
                        otherProperties.put("name", this.semicolonSeparate((String)source.get((Object)"testset")));
                        otherProperties.remove("testset");
                    }
                    if (!otherProperties.containsKey("duration")) {
                        otherProperties.put("duration", 0);
                    }
                    otherProperties.put("testSpecification", testSpecification);
                    ++cnt;
                    Event functionalResult = new Event("functionalResult", otherProperties);
                    this.insertEvent(functionalResult);
                }
            } else {
                LOG.error("Could not retrieve instances of the jobStatus type");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connToOldES != null) {
                connToOldES.disconnect();
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return cnt;
    }

    private String semicolonSeparate(String fitNesseTestCaseName) {
        return fitNesseTestCaseName.replaceAll("\\.", ";");
    }
}

