/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.resources;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.jayway.jsonpath.spi.JsonProviderFactory;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.repository.TestRunsRepository;
import com.xebialabs.xltest.service.EventRepository;
import com.xebialabs.xltest.view.ListOfTestRuns;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/test")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class TestController {
    private static final Logger LOG = LoggerFactory.getLogger(TestController.class);
    private final TestRunsRepository testRunsRepository;
    private final EventRepository eventRepository;

    @Autowired
    public TestController(TestRunsRepository testRunsRepository, EventRepository eventRepository) {
        this.testRunsRepository = testRunsRepository;
        this.eventRepository = eventRepository;
    }

    @GET
    @Path(value="/")
    public ListOfTestRuns getTestRuns(@QueryParam(value="p") List<String> queries, @QueryParam(value="date") String queryDate) {
        LOG.info("Query test runs for fields {} on date {}", queries, (Object)queryDate);
        Map searchParameters = this.addQueryParameters(queries);
        List runs = this.testRunsRepository.getTestRuns(searchParameters);
        if (queryDate != null) {
            DateTime startTime = DateTime.parse((String)queryDate);
            LOG.info("Filtering test runs from {}", (Object)startTime);
            final Interval dateRange = new Interval((ReadableInstant)startTime, (ReadableDuration)Duration.standardDays((long)1L));
            return new ListOfTestRuns(Collections2.filter((Collection)runs, (Predicate)new Predicate<TestRun>(){

                public boolean apply(TestRun testRun) {
                    return testRun.getStartTime() != null && dateRange.contains(testRun.getStartTime().getTime());
                }
            }));
        }
        return new ListOfTestRuns(runs);
    }

    Map addQueryParameters(List<String> queries) {
        HashMap<String, String> searchParameters = new HashMap<String, String>();
        for (String q : queries) {
            String[] nameValue = q.split(":", 2);
            if (nameValue.length != 2) {
                throw new IllegalArgumentException("query should have format 'field:value'");
            }
            searchParameters.put(nameValue[0].trim(), nameValue[1].trim());
        }
        return searchParameters;
    }

    @GET
    @Path(value="/{taskId:[\\w-]+}")
    public String getTestRun(@PathParam(value="taskId") String taskId) {
        TreeMap<String, Boolean> resultObject = new TreeMap<String, Boolean>();
        TestRun testRun = this.testRunsRepository.getTestRun(UUID.fromString(taskId));
        resultObject.put("running", !testRun.isFinished());
        if (testRun.isFinished()) {
            resultObject.put("qualification", testRun.getQualificationResult());
        }
        return JsonProviderFactory.createProvider().toJson(resultObject);
    }

    @POST
    @Path(value="/{testSpecificationId}/{testRunId:.+}")
    public Response receiveEvent(@Context HttpServletRequest request, @PathParam(value="testSpecificationId") String testSpecificationId, @PathParam(value="testRunId") String testRunId, Event event) {
        LOG.info("Received event {} for run {}", (Object)event.getType(), (Object)testRunId);
        this.eventRepository.insert(new Event(UUID.fromString(testRunId), event, Event.props((Object[])new Object[]{"timestamp", System.currentTimeMillis(), "testSpecification", testSpecificationId, "_host", request.getRemoteHost()})));
        return Response.ok().build();
    }
}

