/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.support.nodes.NodeOperationRequest;
import org.elasticsearch.action.support.nodes.TransportNodesOperationAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.service.NodeService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportNodesStatsAction
extends TransportNodesOperationAction<NodesStatsRequest, NodesStatsResponse, NodeStatsRequest, NodeStats> {
    private final NodeService nodeService;

    @Inject
    public TransportNodesStatsAction(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, NodeService nodeService) {
        super(settings, "cluster/nodes/stats", clusterName, threadPool, clusterService, transportService);
        this.nodeService = nodeService;
    }

    @Override
    protected String executor() {
        return "management";
    }

    @Override
    protected NodesStatsResponse newResponse(NodesStatsRequest nodesInfoRequest, AtomicReferenceArray responses) {
        ArrayList<NodeStats> nodeStats = Lists.newArrayList();
        for (int i = 0; i < responses.length(); ++i) {
            Object resp = responses.get(i);
            if (!(resp instanceof NodeStats)) continue;
            nodeStats.add((NodeStats)resp);
        }
        return new NodesStatsResponse(this.clusterName, nodeStats.toArray(new NodeStats[nodeStats.size()]));
    }

    @Override
    protected NodesStatsRequest newRequest() {
        return new NodesStatsRequest();
    }

    @Override
    protected NodeStatsRequest newNodeRequest() {
        return new NodeStatsRequest();
    }

    @Override
    protected NodeStatsRequest newNodeRequest(String nodeId, NodesStatsRequest request) {
        return new NodeStatsRequest(nodeId, request);
    }

    @Override
    protected NodeStats newNodeResponse() {
        return new NodeStats();
    }

    @Override
    protected NodeStats nodeOperation(NodeStatsRequest nodeStatsRequest) throws ElasticsearchException {
        NodesStatsRequest request = nodeStatsRequest.request;
        return this.nodeService.stats(request.indices(), request.os(), request.process(), request.jvm(), request.threadPool(), request.network(), request.fs(), request.transport(), request.http(), request.breaker());
    }

    @Override
    protected boolean accumulateExceptions() {
        return false;
    }

    static class NodeStatsRequest
    extends NodeOperationRequest {
        NodesStatsRequest request;

        NodeStatsRequest() {
        }

        NodeStatsRequest(String nodeId, NodesStatsRequest request) {
            super(request, nodeId);
            this.request = request;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.request = new NodesStatsRequest();
            this.request.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

