/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.restore;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.SnapshotId;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.snapshots.RestoreInfo;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportRestoreSnapshotAction
extends TransportMasterNodeOperationAction<RestoreSnapshotRequest, RestoreSnapshotResponse> {
    private final RestoreService restoreService;

    @Inject
    public TransportRestoreSnapshotAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, RestoreService restoreService) {
        super(settings, "cluster/snapshot/restore", transportService, clusterService, threadPool);
        this.restoreService = restoreService;
    }

    @Override
    protected String executor() {
        return "snapshot";
    }

    @Override
    protected RestoreSnapshotRequest newRequest() {
        return new RestoreSnapshotRequest();
    }

    @Override
    protected RestoreSnapshotResponse newResponse() {
        return new RestoreSnapshotResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(RestoreSnapshotRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA, "");
    }

    @Override
    protected void masterOperation(final RestoreSnapshotRequest request, ClusterState state, final ActionListener<RestoreSnapshotResponse> listener) throws ElasticsearchException {
        RestoreService.RestoreRequest restoreRequest = new RestoreService.RestoreRequest("restore_snapshot[" + request.snapshot() + "]", request.repository(), request.snapshot(), request.indices(), request.indicesOptions(), request.renamePattern(), request.renameReplacement(), request.settings(), request.masterNodeTimeout(), request.includeGlobalState(), request.partial(), request.includeAliases());
        this.restoreService.restoreSnapshot(restoreRequest, new RestoreService.RestoreSnapshotListener(){

            @Override
            public void onResponse(RestoreInfo restoreInfo) {
                if (restoreInfo == null) {
                    if (request.waitForCompletion()) {
                        TransportRestoreSnapshotAction.this.restoreService.addListener(new RestoreService.RestoreCompletionListener(){
                            SnapshotId snapshotId;
                            {
                                this.snapshotId = new SnapshotId(request.repository(), request.snapshot());
                            }

                            @Override
                            public void onRestoreCompletion(SnapshotId snapshotId, RestoreInfo snapshot) {
                                if (this.snapshotId.equals(snapshotId)) {
                                    listener.onResponse(new RestoreSnapshotResponse(snapshot));
                                    TransportRestoreSnapshotAction.this.restoreService.removeListener(this);
                                }
                            }
                        });
                    } else {
                        listener.onResponse(new RestoreSnapshotResponse(null));
                    }
                } else {
                    listener.onResponse(new RestoreSnapshotResponse(restoreInfo));
                }
            }

            @Override
            public void onFailure(Throwable t) {
                listener.onFailure(t);
            }
        });
    }
}

