/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.delete;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.CollectionUtils;

public class DeleteMappingRequest
extends AcknowledgedRequest<DeleteMappingRequest> {
    private String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions(false, false, true, false);
    private String[] types;

    DeleteMappingRequest() {
    }

    public DeleteMappingRequest(String ... indices) {
        this.indices = indices;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        validationException = CollectionUtils.isEmpty(this.types) ? ValidateActions.addValidationError("mapping type is missing", validationException) : this.checkForEmptyString(validationException, this.types);
        validationException = CollectionUtils.isEmpty(this.indices) ? ValidateActions.addValidationError("index is missing", validationException) : this.checkForEmptyString(validationException, this.indices);
        return validationException;
    }

    private ActionRequestValidationException checkForEmptyString(ActionRequestValidationException validationException, String[] strings) {
        boolean containsEmptyString = false;
        for (String string : strings) {
            if (Strings.hasText(string)) continue;
            containsEmptyString = true;
        }
        if (containsEmptyString) {
            validationException = ValidateActions.addValidationError("types must not contain empty strings", validationException);
        }
        return validationException;
    }

    public DeleteMappingRequest indices(String[] indices) {
        this.indices = indices;
        return this;
    }

    public String[] indices() {
        return this.indices;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public DeleteMappingRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public String[] types() {
        return this.types;
    }

    public DeleteMappingRequest types(String ... types) {
        this.types = types;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.types = in.readStringArray();
        this.readTimeout(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeStringArrayNullable(this.types);
        this.writeTimeout(out);
    }
}

