/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.settings.get;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;

public class GetSettingsResponse
extends ActionResponse {
    private ImmutableOpenMap<String, Settings> indexToSettings = ImmutableOpenMap.of();

    public GetSettingsResponse(ImmutableOpenMap<String, Settings> indexToSettings) {
        this.indexToSettings = indexToSettings;
    }

    GetSettingsResponse() {
    }

    public ImmutableOpenMap<String, Settings> getIndexToSettings() {
        return this.indexToSettings;
    }

    public String getSetting(String index, String setting) {
        Settings settings = this.indexToSettings.get(index);
        if (setting != null) {
            return settings.get(setting);
        }
        return null;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        ImmutableOpenMap.Builder<String, Settings> builder = ImmutableOpenMap.builder();
        for (int i = 0; i < size; ++i) {
            builder.put(in.readString(), ImmutableSettings.readSettingsFromStream(in));
        }
        this.indexToSettings = builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.indexToSettings.size());
        for (ObjectObjectCursor<String, Settings> objectObjectCursor : this.indexToSettings) {
            out.writeString((String)objectObjectCursor.key);
            ImmutableSettings.writeSettingsToStream((Settings)objectObjectCursor.value, out);
        }
    }
}

