/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.indexedscripts.get;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.indexedscripts.get.GetIndexedScriptRequest;
import org.elasticsearch.action.indexedscripts.get.GetIndexedScriptResponse;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetIndexedScriptAction
extends HandledTransportAction<GetIndexedScriptRequest, GetIndexedScriptResponse> {
    public static final boolean REFRESH_FORCE = false;
    ScriptService scriptService;
    Client client;

    @Inject
    public TransportGetIndexedScriptAction(Settings settings, ThreadPool threadPool, ScriptService scriptService, TransportService transportService, Client client) {
        super(settings, "getIndexedScript", threadPool, transportService);
        this.scriptService = scriptService;
        this.client = client;
    }

    @Override
    public GetIndexedScriptRequest newRequestInstance() {
        return new GetIndexedScriptRequest();
    }

    @Override
    public void doExecute(GetIndexedScriptRequest request, ActionListener<GetIndexedScriptResponse> listener) {
        try {
            GetResponse scriptResponse = this.scriptService.queryScriptIndex(this.client, request.scriptLang(), request.id(), request.version(), request.versionType());
            listener.onResponse(new GetIndexedScriptResponse(scriptResponse));
        }
        catch (Throwable e) {
            listener.onFailure(e);
        }
    }
}

