/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportService;

public class TransportMultiSearchAction
extends TransportAction<MultiSearchRequest, MultiSearchResponse> {
    private final ClusterService clusterService;
    private final TransportSearchAction searchAction;

    @Inject
    public TransportMultiSearchAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, TransportSearchAction searchAction) {
        super(settings, "msearch", threadPool);
        this.clusterService = clusterService;
        this.searchAction = searchAction;
        transportService.registerHandler("msearch", new TransportHandler());
    }

    @Override
    protected void doExecute(MultiSearchRequest request, final ActionListener<MultiSearchResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        final AtomicArray responses = new AtomicArray(request.requests().size());
        final AtomicInteger counter = new AtomicInteger(responses.length());
        for (int i = 0; i < responses.length(); ++i) {
            final int index = i;
            this.searchAction.execute((ActionRequest)request.requests().get(i), new ActionListener<SearchResponse>(){

                @Override
                public void onResponse(SearchResponse searchResponse) {
                    responses.set(index, new MultiSearchResponse.Item(searchResponse, null));
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    responses.set(index, new MultiSearchResponse.Item(null, ExceptionsHelper.detailedMessage(e)));
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                private void finishHim() {
                    listener.onResponse(new MultiSearchResponse(responses.toArray(new MultiSearchResponse.Item[responses.length()])));
                }
            });
        }
    }

    class TransportHandler
    extends BaseTransportRequestHandler<MultiSearchRequest> {
        TransportHandler() {
        }

        @Override
        public MultiSearchRequest newInstance() {
            return new MultiSearchRequest();
        }

        @Override
        public void messageReceived(final MultiSearchRequest request, final TransportChannel channel) throws Exception {
            request.listenerThreaded(false);
            TransportMultiSearchAction.this.execute(request, new ActionListener<MultiSearchResponse>(){

                @Override
                public void onResponse(MultiSearchResponse response) {
                    try {
                        channel.sendResponse(response);
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportMultiSearchAction.this.logger.warn("Failed to send error response for action [msearch] and request [" + request + "]", e1, new Object[0]);
                    }
                }
            });
        }

        @Override
        public String executor() {
            return "same";
        }
    }
}

