/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.index.engine.DocumentAlreadyExistsException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportShardReplicationOperationAction<Request extends ShardReplicationOperationRequest, ReplicaRequest extends ShardReplicationOperationRequest, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    protected final TransportService transportService;
    protected final ClusterService clusterService;
    protected final IndicesService indicesService;
    protected final ShardStateAction shardStateAction;
    protected final ReplicationType defaultReplicationType;
    protected final WriteConsistencyLevel defaultWriteConsistencyLevel;
    protected final TransportRequestOptions transportOptions;
    final String transportReplicaAction;
    final String executor;
    final boolean checkWriteConsistency;

    protected TransportShardReplicationOperationAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction) {
        super(settings, actionName, threadPool);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.shardStateAction = shardStateAction;
        this.transportReplicaAction = this.transportReplicaAction();
        this.executor = this.executor();
        this.checkWriteConsistency = this.checkWriteConsistency();
        transportService.registerHandler(actionName, new OperationTransportHandler());
        transportService.registerHandler(this.transportReplicaAction, new ReplicaOperationTransportHandler());
        this.transportOptions = this.transportOptions();
        this.defaultReplicationType = ReplicationType.fromString(settings.get("action.replication_type", "sync"));
        this.defaultWriteConsistencyLevel = WriteConsistencyLevel.fromString(settings.get("action.write_consistency", "quorum"));
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        new AsyncShardOperationAction(this, request, listener).start();
    }

    protected abstract Request newRequestInstance();

    protected abstract ReplicaRequest newReplicaRequestInstance();

    protected abstract Response newResponseInstance();

    protected abstract String executor();

    protected abstract PrimaryResponse<Response, ReplicaRequest> shardOperationOnPrimary(ClusterState var1, PrimaryOperationRequest var2);

    protected abstract void shardOperationOnReplica(ReplicaOperationRequest var1);

    protected void postPrimaryOperation(Request request, PrimaryResponse<Response, ReplicaRequest> response) {
    }

    protected abstract ShardIterator shards(ClusterState var1, Request var2) throws ElasticsearchException;

    protected abstract boolean checkWriteConsistency();

    protected abstract ClusterBlockException checkGlobalBlock(ClusterState var1, Request var2);

    protected abstract ClusterBlockException checkRequestBlock(ClusterState var1, Request var2);

    protected boolean resolveRequest(ClusterState state, Request request, ActionListener<Response> listener) {
        ((ShardReplicationOperationRequest)request).index(state.metaData().concreteSingleIndex(((ShardReplicationOperationRequest)request).index()));
        return true;
    }

    protected TransportRequestOptions transportOptions() {
        return TransportRequestOptions.EMPTY;
    }

    protected boolean ignoreReplicas() {
        return false;
    }

    private String transportReplicaAction() {
        return this.actionName + "/replica";
    }

    protected boolean retryPrimaryException(Throwable e) {
        return TransportActions.isShardNotAvailableException(e);
    }

    boolean ignoreReplicaException(Throwable e) {
        if (TransportActions.isShardNotAvailableException(e)) {
            return true;
        }
        Throwable cause = ExceptionsHelper.unwrapCause(e);
        if (cause instanceof VersionConflictEngineException) {
            return true;
        }
        return cause instanceof DocumentAlreadyExistsException;
    }

    private void failReplicaIfNeeded(String index, int shardId, Throwable t) {
        this.logger.trace("failure on replica [{}][{}]", t, index, shardId);
        if (!this.ignoreReplicaException(t)) {
            IndexService indexService = this.indicesService.indexService(index);
            if (indexService == null) {
                this.logger.debug("ignoring failed replica [{}][{}] because index was already removed.", index, shardId);
                return;
            }
            IndexShard indexShard = indexService.shard(shardId);
            if (indexShard == null) {
                this.logger.debug("ignoring failed replica [{}][{}] because index was already removed.", index, shardId);
                return;
            }
            indexShard.failShard(this.actionName + " failed on replica", t);
        }
    }

    public static class PrimaryResponse<Response, ReplicaRequest> {
        private final ReplicaRequest replicaRequest;
        private final Response response;
        private final Object payload;

        public PrimaryResponse(ReplicaRequest replicaRequest, Response response, Object payload) {
            this.replicaRequest = replicaRequest;
            this.response = response;
            this.payload = payload;
        }

        public ReplicaRequest replicaRequest() {
            return this.replicaRequest;
        }

        public Response response() {
            return this.response;
        }

        public Object payload() {
            return this.payload;
        }
    }

    protected static class AsyncShardOperationAction {
        private final ActionListener<Response> listener;
        private final Request request;
        private volatile ShardIterator shardIt;
        private final AtomicBoolean primaryOperationStarted = new AtomicBoolean();
        private final ReplicationType replicationType;
        private volatile ClusterStateObserver observer;
        final /* synthetic */ TransportShardReplicationOperationAction this$0;

        AsyncShardOperationAction(Request request, ActionListener<Response> listener) {
            this.this$0 = var1_1;
            this.request = request;
            this.listener = listener;
            this.replicationType = ((ShardReplicationOperationRequest)request).replicationType() != ReplicationType.DEFAULT ? ((ShardReplicationOperationRequest)request).replicationType() : var1_1.defaultReplicationType;
        }

        public void start() {
            this.observer = new ClusterStateObserver(this.this$0.clusterService, ((ShardReplicationOperationRequest)this.request).timeout(), this.this$0.logger);
            this.doStart();
        }

        protected boolean doStart() throws ElasticsearchException {
            ShardRouting shardX;
            try {
                ClusterBlockException blockException = this.this$0.checkGlobalBlock(this.observer.observedState(), this.request);
                if (blockException != null) {
                    if (blockException.retryable()) {
                        this.this$0.logger.trace("cluster is blocked ({}), scheduling a retry", blockException.getMessage());
                        this.retry(blockException);
                        return false;
                    }
                    throw blockException;
                }
                if (!this.this$0.resolveRequest(this.observer.observedState(), this.request, this.listener)) {
                    return true;
                }
                blockException = this.this$0.checkRequestBlock(this.observer.observedState(), this.request);
                if (blockException != null) {
                    if (blockException.retryable()) {
                        this.this$0.logger.trace("cluster is blocked ({}), scheduling a retry", blockException.getMessage());
                        this.retry(blockException);
                        return false;
                    }
                    throw blockException;
                }
                this.shardIt = this.this$0.shards(this.observer.observedState(), this.request);
            }
            catch (Throwable e) {
                this.listener.onFailure(e);
                return true;
            }
            if (this.shardIt.size() == 0) {
                this.this$0.logger.trace("no shard instances known for shard [{}], scheduling a retry", this.shardIt.shardId());
                this.retry(null);
                return false;
            }
            boolean foundPrimary = false;
            while ((shardX = this.shardIt.nextOrNull()) != null) {
                final ShardRouting shard = shardX;
                if (!shard.primary()) continue;
                if (!shard.active() || !this.observer.observedState().nodes().nodeExists(shard.currentNodeId())) {
                    this.this$0.logger.trace("primary shard [{}] is not yet active or we do not know the node it is assigned to [{}], scheduling a retry.", shard.shardId(), shard.currentNodeId());
                    this.retry(null);
                    return false;
                }
                if (this.this$0.checkWriteConsistency) {
                    WriteConsistencyLevel consistencyLevel = this.this$0.defaultWriteConsistencyLevel;
                    if (((ShardReplicationOperationRequest)this.request).consistencyLevel() != WriteConsistencyLevel.DEFAULT) {
                        consistencyLevel = ((ShardReplicationOperationRequest)this.request).consistencyLevel();
                    }
                    int requiredNumber = 1;
                    if (consistencyLevel == WriteConsistencyLevel.QUORUM && this.shardIt.size() > 2) {
                        requiredNumber = this.shardIt.size() / 2 + 1;
                    } else if (consistencyLevel == WriteConsistencyLevel.ALL) {
                        requiredNumber = this.shardIt.size();
                    }
                    if (this.shardIt.sizeActive() < requiredNumber) {
                        this.this$0.logger.trace("not enough active copies of shard [{}] to meet write consistency of [{}] (have {}, needed {}), scheduling a retry.", new Object[]{shard.shardId(), consistencyLevel, this.shardIt.sizeActive(), requiredNumber});
                        this.retry(null);
                        return false;
                    }
                }
                if (!this.primaryOperationStarted.compareAndSet(false, true)) {
                    return true;
                }
                foundPrimary = true;
                if (shard.currentNodeId().equals(this.observer.observedState().nodes().localNodeId())) {
                    try {
                        if (((ShardReplicationOperationRequest)this.request).operationThreaded()) {
                            ((ShardReplicationOperationRequest)this.request).beforeLocalFork();
                            this.this$0.threadPool.executor(this.this$0.executor).execute(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        AsyncShardOperationAction.this.performOnPrimary(shard.id(), shard, AsyncShardOperationAction.this.observer.observedState());
                                    }
                                    catch (Throwable t) {
                                        AsyncShardOperationAction.this.listener.onFailure(t);
                                    }
                                }
                            });
                            break;
                        }
                        this.performOnPrimary(shard.id(), shard, this.observer.observedState());
                    }
                    catch (Throwable t) {
                        this.listener.onFailure(t);
                    }
                    break;
                }
                DiscoveryNode node = this.observer.observedState().nodes().get(shard.currentNodeId());
                this.this$0.transportService.sendRequest(node, this.this$0.actionName, (TransportRequest)this.request, this.this$0.transportOptions, new BaseTransportResponseHandler<Response>(){

                    @Override
                    public Response newInstance() {
                        return AsyncShardOperationAction.this.this$0.newResponseInstance();
                    }

                    @Override
                    public String executor() {
                        return "same";
                    }

                    @Override
                    public void handleResponse(Response response) {
                        AsyncShardOperationAction.this.listener.onResponse(response);
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        if (exp.unwrapCause() instanceof ConnectTransportException || exp.unwrapCause() instanceof NodeClosedException || AsyncShardOperationAction.this.this$0.retryPrimaryException(exp)) {
                            AsyncShardOperationAction.this.primaryOperationStarted.set(false);
                            AsyncShardOperationAction.this.this$0.logger.trace("received an error from node the primary was assigned to ({}), scheduling a retry", exp.getMessage());
                            AsyncShardOperationAction.this.retry(null);
                        } else {
                            AsyncShardOperationAction.this.listener.onFailure(exp);
                        }
                    }
                });
                break;
            }
            if (!foundPrimary) {
                this.this$0.logger.trace("couldn't find a eligible primary shard, scheduling for retry.", new Object[0]);
                this.retry(null);
                return false;
            }
            return true;
        }

        void retry(final @Nullable Throwable failure) {
            if (this.observer.isTimedOut()) {
                return;
            }
            ((ShardReplicationOperationRequest)this.request).beforeLocalFork();
            ((ShardReplicationOperationRequest)this.request).operationThreaded(true);
            this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    AsyncShardOperationAction.this.doStart();
                }

                @Override
                public void onClusterServiceClose() {
                    AsyncShardOperationAction.this.listener.onFailure(new NodeClosedException(AsyncShardOperationAction.this.this$0.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    if (AsyncShardOperationAction.this.doStart()) {
                        return;
                    }
                    AsyncShardOperationAction.this.raiseTimeoutFailure(timeout, failure);
                }
            });
        }

        void raiseTimeoutFailure(TimeValue timeout, @Nullable Throwable failure) {
            if (failure == null) {
                failure = this.shardIt == null ? new UnavailableShardsException(null, "no available shards: Timeout waiting for [" + timeout + "], request: " + this.request.toString()) : new UnavailableShardsException(this.shardIt.shardId(), "[" + this.shardIt.size() + "] shardIt, [" + this.shardIt.sizeActive() + "] active : Timeout waiting for [" + timeout + "], request: " + this.request.toString());
            }
            this.listener.onFailure(failure);
        }

        void performOnPrimary(int primaryShardId, ShardRouting shard, ClusterState clusterState) {
            try {
                PrimaryResponse response = this.this$0.shardOperationOnPrimary(clusterState, new PrimaryOperationRequest(this.this$0, primaryShardId, this.request));
                this.performReplicas(response);
            }
            catch (Throwable e) {
                if (this.this$0.retryPrimaryException(e)) {
                    this.primaryOperationStarted.set(false);
                    this.this$0.logger.trace("had an error while performing operation on primary ({}), scheduling a retry.", e.getMessage());
                    this.retry(e);
                    return;
                }
                if (e instanceof ElasticsearchException && ((ElasticsearchException)e).status() == RestStatus.CONFLICT) {
                    if (this.this$0.logger.isTraceEnabled()) {
                        this.this$0.logger.trace(shard.shortSummary() + ": Failed to execute [" + this.request + "]", e, new Object[0]);
                    }
                } else if (this.this$0.logger.isDebugEnabled()) {
                    this.this$0.logger.debug(shard.shortSummary() + ": Failed to execute [" + this.request + "]", e, new Object[0]);
                }
                this.listener.onFailure(e);
            }
        }

        void performReplicas(PrimaryResponse<Response, ReplicaRequest> response) {
            ShardRouting shard;
            if (this.this$0.ignoreReplicas()) {
                this.this$0.postPrimaryOperation(this.request, response);
                this.listener.onResponse(response.response());
                return;
            }
            ClusterState newState = this.this$0.clusterService.state();
            ShardRouting newPrimaryShard = null;
            if (this.observer.observedState() != newState) {
                this.shardIt.reset();
                ShardRouting originalPrimaryShard = null;
                while ((shard = this.shardIt.nextOrNull()) != null) {
                    if (!shard.primary()) continue;
                    originalPrimaryShard = shard;
                    break;
                }
                if (originalPrimaryShard == null || !originalPrimaryShard.active()) {
                    throw new ElasticsearchIllegalStateException("unexpected state, failed to find primary shard on an index operation that succeeded");
                }
                this.observer.reset(newState);
                this.shardIt = this.this$0.shards(newState, this.request);
                while ((shard = this.shardIt.nextOrNull()) != null) {
                    if (!shard.primary()) continue;
                    newPrimaryShard = originalPrimaryShard.currentNodeId().equals(shard.currentNodeId()) ? null : shard;
                    break;
                }
                this.shardIt.reset();
                ((ShardReplicationOperationRequest)this.request).setCanHaveDuplicates();
            } else {
                this.shardIt.reset();
                while ((shard = this.shardIt.nextOrNull()) != null) {
                    if (shard.state() == ShardRoutingState.STARTED) continue;
                    ((ShardReplicationOperationRequest)this.request).setCanHaveDuplicates();
                }
                this.shardIt.reset();
            }
            int replicaCounter = this.shardIt.assignedReplicasIncludingRelocating();
            if (newPrimaryShard != null) {
                ++replicaCounter;
            }
            if (replicaCounter == 0) {
                this.this$0.postPrimaryOperation(this.request, response);
                this.listener.onResponse(response.response());
                return;
            }
            if (this.replicationType == ReplicationType.ASYNC) {
                this.this$0.postPrimaryOperation(this.request, response);
                this.listener.onResponse(response.response());
                replicaCounter = Integer.MIN_VALUE;
            }
            AtomicInteger counter = new AtomicInteger(++replicaCounter);
            IndexMetaData indexMetaData = this.observer.observedState().metaData().index(((ShardReplicationOperationRequest)this.request).index());
            if (newPrimaryShard != null) {
                this.performOnReplica(response, counter, newPrimaryShard, newPrimaryShard.currentNodeId(), indexMetaData);
            }
            this.shardIt.reset();
            while ((shard = this.shardIt.nextOrNull()) != null) {
                if (shard.unassigned()) continue;
                boolean doOnlyOnRelocating = false;
                if (shard.primary()) {
                    if (!shard.relocating()) continue;
                    doOnlyOnRelocating = true;
                }
                if (!doOnlyOnRelocating) {
                    this.performOnReplica(response, counter, shard, shard.currentNodeId(), indexMetaData);
                }
                if (!shard.relocating()) continue;
                this.performOnReplica(response, counter, shard, shard.relocatingNodeId(), indexMetaData);
            }
            this.this$0.postPrimaryOperation(this.request, response);
            if (counter.decrementAndGet() == 0) {
                this.listener.onResponse(response.response());
            }
        }

        void performOnReplica(final PrimaryResponse<Response, ReplicaRequest> response, final AtomicInteger counter, final ShardRouting shard, String nodeId, final IndexMetaData indexMetaData) {
            block11: {
                if (!this.observer.observedState().nodes().nodeExists(nodeId)) {
                    if (counter.decrementAndGet() == 0) {
                        this.listener.onResponse(response.response());
                    }
                    return;
                }
                final ReplicaOperationRequest shardRequest = new ReplicaOperationRequest(this.this$0, this.shardIt.shardId().id(), (ShardReplicationOperationRequest)response.replicaRequest());
                if (!nodeId.equals(this.observer.observedState().nodes().localNodeId())) {
                    final DiscoveryNode node = this.observer.observedState().nodes().get(nodeId);
                    this.this$0.transportService.sendRequest(node, this.this$0.transportReplicaAction, shardRequest, this.this$0.transportOptions, new EmptyTransportResponseHandler("same"){

                        @Override
                        public void handleResponse(TransportResponse.Empty vResponse) {
                            this.finishIfPossible();
                        }

                        @Override
                        public void handleException(TransportException exp) {
                            AsyncShardOperationAction.this.this$0.logger.trace("[{}] Transport failure during replica request [{}] ", exp, node, AsyncShardOperationAction.this.request);
                            if (!AsyncShardOperationAction.this.this$0.ignoreReplicaException(exp)) {
                                AsyncShardOperationAction.this.this$0.logger.warn("Failed to perform " + AsyncShardOperationAction.this.this$0.actionName + " on remote replica " + node + AsyncShardOperationAction.this.shardIt.shardId(), exp, new Object[0]);
                                AsyncShardOperationAction.this.this$0.shardStateAction.shardFailed(shard, indexMetaData.getUUID(), "Failed to perform [" + AsyncShardOperationAction.this.this$0.actionName + "] on replica, message [" + ExceptionsHelper.detailedMessage(exp) + "]");
                            }
                            this.finishIfPossible();
                        }

                        private void finishIfPossible() {
                            if (counter.decrementAndGet() == 0) {
                                AsyncShardOperationAction.this.listener.onResponse(response.response());
                            }
                        }
                    });
                } else {
                    if (((ShardReplicationOperationRequest)this.request).operationThreaded()) {
                        ((ShardReplicationOperationRequest)this.request).beforeLocalFork();
                        try {
                            this.this$0.threadPool.executor(this.this$0.executor).execute(new AbstractRunnable(){

                                @Override
                                public void run() {
                                    try {
                                        AsyncShardOperationAction.this.this$0.shardOperationOnReplica(shardRequest);
                                    }
                                    catch (Throwable e) {
                                        AsyncShardOperationAction.this.this$0.failReplicaIfNeeded(shard.index(), shard.id(), e);
                                    }
                                    if (counter.decrementAndGet() == 0) {
                                        AsyncShardOperationAction.this.listener.onResponse(response.response());
                                    }
                                }

                                @Override
                                public boolean isForceExecution() {
                                    return true;
                                }
                            });
                        }
                        catch (Throwable e) {
                            this.this$0.failReplicaIfNeeded(shard.index(), shard.id(), e);
                            if (counter.decrementAndGet() == 0) {
                                this.listener.onResponse(response.response());
                            }
                            break block11;
                        }
                    }
                    try {
                        this.this$0.shardOperationOnReplica(shardRequest);
                    }
                    catch (Throwable e) {
                        this.this$0.failReplicaIfNeeded(shard.index(), shard.id(), e);
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.listener.onResponse(response.response());
                    }
                }
            }
        }
    }

    protected class ReplicaOperationRequest
    extends TransportRequest {
        public int shardId;
        public ReplicaRequest request;

        public ReplicaOperationRequest() {
        }

        public ReplicaOperationRequest(int shardId, ReplicaRequest request) {
            super((TransportRequest)request);
            this.shardId = shardId;
            this.request = request;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardId = in.readVInt();
            this.request = TransportShardReplicationOperationAction.this.newReplicaRequestInstance();
            ((ShardReplicationOperationRequest)this.request).readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(this.shardId);
            ((ShardReplicationOperationRequest)this.request).writeTo(out);
        }
    }

    protected class PrimaryOperationRequest
    implements Streamable {
        public int shardId;
        public Request request;

        public PrimaryOperationRequest() {
        }

        public PrimaryOperationRequest(int shardId, Request request) {
            this.shardId = shardId;
            this.request = request;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.shardId = in.readVInt();
            this.request = TransportShardReplicationOperationAction.this.newRequestInstance();
            ((ShardReplicationOperationRequest)this.request).readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.shardId);
            ((ShardReplicationOperationRequest)this.request).writeTo(out);
        }
    }

    class ReplicaOperationTransportHandler
    extends BaseTransportRequestHandler<ReplicaOperationRequest> {
        ReplicaOperationTransportHandler() {
        }

        @Override
        public ReplicaOperationRequest newInstance() {
            return new ReplicaOperationRequest();
        }

        @Override
        public String executor() {
            return TransportShardReplicationOperationAction.this.executor;
        }

        @Override
        public boolean isForceExecution() {
            return true;
        }

        @Override
        public void messageReceived(ReplicaOperationRequest request, TransportChannel channel) throws Exception {
            try {
                TransportShardReplicationOperationAction.this.shardOperationOnReplica(request);
            }
            catch (Throwable t) {
                TransportShardReplicationOperationAction.this.failReplicaIfNeeded(((ShardReplicationOperationRequest)request.request).index(), request.shardId, t);
                throw t;
            }
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    class OperationTransportHandler
    extends BaseTransportRequestHandler<Request> {
        OperationTransportHandler() {
        }

        @Override
        public Request newInstance() {
            return TransportShardReplicationOperationAction.this.newRequestInstance();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel) throws Exception {
            ((ActionRequest)request).listenerThreaded(false);
            ((ShardReplicationOperationRequest)request).operationThreaded(true);
            TransportShardReplicationOperationAction.this.execute(request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response result) {
                    try {
                        channel.sendResponse((TransportResponse)result);
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Throwable e1) {
                        TransportShardReplicationOperationAction.this.logger.warn("Failed to send response for " + TransportShardReplicationOperationAction.this.actionName, e1, new Object[0]);
                    }
                }
            });
        }
    }
}

