/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.SnapshotId;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.shard.ShardId;

public class SnapshotMetaData
implements MetaData.Custom {
    public static final String TYPE = "snapshots";
    public static final Factory FACTORY = new Factory();
    private final ImmutableList<Entry> entries;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotMetaData that = (SnapshotMetaData)o;
        return this.entries.equals(that.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public SnapshotMetaData(ImmutableList<Entry> entries) {
        this.entries = entries;
    }

    public SnapshotMetaData(Entry ... entries) {
        this.entries = ImmutableList.copyOf(entries);
    }

    public ImmutableList<Entry> entries() {
        return this.entries;
    }

    public Entry snapshot(SnapshotId snapshotId) {
        for (Entry entry : this.entries) {
            if (!snapshotId.equals(entry.snapshotId())) continue;
            return entry;
        }
        return null;
    }

    public static class Factory
    implements MetaData.Custom.Factory<SnapshotMetaData> {
        @Override
        public String type() {
            return SnapshotMetaData.TYPE;
        }

        @Override
        public SnapshotMetaData readFrom(StreamInput in) throws IOException {
            Entry[] entries = new Entry[in.readVInt()];
            for (int i = 0; i < entries.length; ++i) {
                SnapshotId snapshotId = SnapshotId.readSnapshotId(in);
                boolean includeGlobalState = in.readBoolean();
                State state = State.fromValue(in.readByte());
                int indices = in.readVInt();
                ImmutableList.Builder indexBuilder = ImmutableList.builder();
                for (int j = 0; j < indices; ++j) {
                    indexBuilder.add(in.readString());
                }
                ImmutableMap.Builder<ShardId, ShardSnapshotStatus> builder = ImmutableMap.builder();
                int shards = in.readVInt();
                for (int j = 0; j < shards; ++j) {
                    ShardId shardId = ShardId.readShardId(in);
                    String nodeId = in.readOptionalString();
                    State shardState = State.fromValue(in.readByte());
                    builder.put(shardId, new ShardSnapshotStatus(nodeId, shardState));
                }
                entries[i] = new Entry(snapshotId, includeGlobalState, state, (ImmutableList<String>)indexBuilder.build(), builder.build());
            }
            return new SnapshotMetaData(entries);
        }

        @Override
        public void writeTo(SnapshotMetaData repositories, StreamOutput out) throws IOException {
            out.writeVInt(repositories.entries().size());
            for (Entry entry : repositories.entries()) {
                entry.snapshotId().writeTo(out);
                out.writeBoolean(entry.includeGlobalState());
                out.writeByte(entry.state().value());
                out.writeVInt(entry.indices().size());
                for (String index : entry.indices()) {
                    out.writeString(index);
                }
                out.writeVInt(entry.shards().size());
                for (Map.Entry shardEntry : entry.shards().entrySet()) {
                    ((ShardId)shardEntry.getKey()).writeTo(out);
                    out.writeOptionalString(((ShardSnapshotStatus)shardEntry.getValue()).nodeId());
                    out.writeByte(((ShardSnapshotStatus)shardEntry.getValue()).state().value());
                }
            }
        }

        @Override
        public SnapshotMetaData fromXContent(XContentParser parser) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toXContent(SnapshotMetaData customIndexMetaData, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startArray(SnapshotMetaData.TYPE);
            for (Entry entry : customIndexMetaData.entries()) {
                this.toXContent(entry, builder, params);
            }
            builder.endArray();
        }

        @Override
        public void toXContent(Entry entry, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("repository", entry.snapshotId().getRepository());
            builder.field("snapshot", entry.snapshotId().getSnapshot());
            builder.field("include_global_state", entry.includeGlobalState());
            builder.field("state", (Object)entry.state());
            builder.startArray("indices");
            for (String index : entry.indices()) {
                builder.value(index);
            }
            builder.endArray();
            builder.startArray("shards");
            for (Map.Entry shardEntry : entry.shards.entrySet()) {
                ShardId shardId = (ShardId)shardEntry.getKey();
                ShardSnapshotStatus status = (ShardSnapshotStatus)shardEntry.getValue();
                builder.startObject();
                builder.field("index", shardId.getIndex());
                builder.field("shard", shardId.getId());
                builder.field("state", (Object)status.state());
                builder.field("node", status.nodeId());
                builder.endObject();
            }
            builder.endArray();
            builder.endObject();
        }

        @Override
        public boolean isPersistent() {
            return false;
        }
    }

    public static enum State {
        INIT(0, false, false),
        STARTED(1, false, false),
        SUCCESS(2, true, false),
        FAILED(3, true, true),
        ABORTED(4, false, true),
        MISSING(5, true, true),
        WAITING(6, false, false);

        private byte value;
        private boolean completed;
        private boolean failed;

        private State(byte value, boolean completed, boolean failed) {
            this.value = value;
            this.completed = completed;
            this.failed = failed;
        }

        public byte value() {
            return this.value;
        }

        public boolean completed() {
            return this.completed;
        }

        public boolean failed() {
            return this.failed;
        }

        public static State fromValue(byte value) {
            switch (value) {
                case 0: {
                    return INIT;
                }
                case 1: {
                    return STARTED;
                }
                case 2: {
                    return SUCCESS;
                }
                case 3: {
                    return FAILED;
                }
                case 4: {
                    return ABORTED;
                }
                case 5: {
                    return MISSING;
                }
                case 6: {
                    return WAITING;
                }
            }
            throw new ElasticsearchIllegalArgumentException("No snapshot state for value [" + value + "]");
        }
    }

    public static class ShardSnapshotStatus {
        private State state;
        private String nodeId;
        private String reason;

        private ShardSnapshotStatus() {
        }

        public ShardSnapshotStatus(String nodeId) {
            this(nodeId, State.INIT);
        }

        public ShardSnapshotStatus(String nodeId, State state) {
            this(nodeId, state, null);
        }

        public ShardSnapshotStatus(String nodeId, State state, String reason) {
            this.nodeId = nodeId;
            this.state = state;
            this.reason = reason;
        }

        public State state() {
            return this.state;
        }

        public String nodeId() {
            return this.nodeId;
        }

        public String reason() {
            return this.reason;
        }

        public static ShardSnapshotStatus readShardSnapshotStatus(StreamInput in) throws IOException {
            ShardSnapshotStatus shardSnapshotStatus = new ShardSnapshotStatus();
            shardSnapshotStatus.readFrom(in);
            return shardSnapshotStatus;
        }

        public void readFrom(StreamInput in) throws IOException {
            this.nodeId = in.readOptionalString();
            this.state = State.fromValue(in.readByte());
            this.reason = in.readOptionalString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.nodeId);
            out.writeByte(this.state.value);
            out.writeOptionalString(this.reason);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShardSnapshotStatus status = (ShardSnapshotStatus)o;
            if (this.nodeId != null ? !this.nodeId.equals(status.nodeId) : status.nodeId != null) {
                return false;
            }
            if (this.reason != null ? !this.reason.equals(status.reason) : status.reason != null) {
                return false;
            }
            return this.state == status.state;
        }

        public int hashCode() {
            int result = this.state != null ? this.state.hashCode() : 0;
            result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
            result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
            return result;
        }
    }

    public static class Entry {
        private final State state;
        private final SnapshotId snapshotId;
        private final boolean includeGlobalState;
        private final ImmutableMap<ShardId, ShardSnapshotStatus> shards;
        private final ImmutableList<String> indices;
        private final ImmutableMap<String, ImmutableList<ShardId>> waitingIndices;

        public Entry(SnapshotId snapshotId, boolean includeGlobalState, State state, ImmutableList<String> indices, ImmutableMap<ShardId, ShardSnapshotStatus> shards) {
            this.state = state;
            this.snapshotId = snapshotId;
            this.includeGlobalState = includeGlobalState;
            this.indices = indices;
            if (shards == null) {
                this.shards = ImmutableMap.of();
                this.waitingIndices = ImmutableMap.of();
            } else {
                this.shards = shards;
                this.waitingIndices = this.findWaitingIndices(shards);
            }
        }

        public SnapshotId snapshotId() {
            return this.snapshotId;
        }

        public ImmutableMap<ShardId, ShardSnapshotStatus> shards() {
            return this.shards;
        }

        public State state() {
            return this.state;
        }

        public ImmutableList<String> indices() {
            return this.indices;
        }

        public ImmutableMap<String, ImmutableList<ShardId>> waitingIndices() {
            return this.waitingIndices;
        }

        public boolean includeGlobalState() {
            return this.includeGlobalState;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.includeGlobalState != entry.includeGlobalState) {
                return false;
            }
            if (!this.indices.equals(entry.indices)) {
                return false;
            }
            if (!this.shards.equals(entry.shards)) {
                return false;
            }
            if (!this.snapshotId.equals(entry.snapshotId)) {
                return false;
            }
            return this.state == entry.state;
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = 31 * result + this.snapshotId.hashCode();
            result = 31 * result + (this.includeGlobalState ? 1 : 0);
            result = 31 * result + this.shards.hashCode();
            result = 31 * result + this.indices.hashCode();
            return result;
        }

        private ImmutableMap<String, ImmutableList<ShardId>> findWaitingIndices(ImmutableMap<ShardId, ShardSnapshotStatus> shards) {
            HashMap waitingIndicesMap = Maps.newHashMap();
            for (Map.Entry entry : shards.entrySet()) {
                if (((ShardSnapshotStatus)entry.getValue()).state() != State.WAITING) continue;
                ImmutableList.Builder waitingShards = (ImmutableList.Builder)waitingIndicesMap.get(((ShardId)entry.getKey()).getIndex());
                if (waitingShards == null) {
                    waitingShards = ImmutableList.builder();
                    waitingIndicesMap.put(((ShardId)entry.getKey()).getIndex(), waitingShards);
                }
                waitingShards.add(entry.getKey());
            }
            if (!waitingIndicesMap.isEmpty()) {
                ImmutableMap.Builder waitingIndicesBuilder = ImmutableMap.builder();
                for (Map.Entry entry : waitingIndicesMap.entrySet()) {
                    waitingIndicesBuilder.put(entry.getKey(), ((ImmutableList.Builder)entry.getValue()).build());
                }
                return waitingIndicesBuilder.build();
            }
            return ImmutableMap.of();
        }
    }
}

