/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine.internal;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.engine.internal.VersionValue;

class LiveVersionMap
implements ReferenceManager.RefreshListener,
Accountable {
    private final Map<BytesRef, VersionValue> tombstones = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private volatile Maps maps = new Maps();
    private ReferenceManager mgr;
    private static final int BASE_BYTES_PER_BYTESREF = RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8 + RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
    private static final int BASE_BYTES_PER_CHM_ENTRY = RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 4 + 5 * RamUsageEstimator.NUM_BYTES_OBJECT_REF;
    final AtomicLong ramBytesUsedCurrent = new AtomicLong();
    final AtomicLong ramBytesUsedTombstones = new AtomicLong();

    LiveVersionMap() {
    }

    synchronized void setManager(ReferenceManager newMgr) {
        if (this.mgr != null) {
            this.mgr.removeListener((ReferenceManager.RefreshListener)this);
        }
        this.mgr = newMgr;
        this.maps = new Maps();
        this.mgr.addListener((ReferenceManager.RefreshListener)this);
    }

    public void beforeRefresh() throws IOException {
        this.maps = new Maps(ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency(), this.maps.current);
        this.ramBytesUsedCurrent.set(0L);
    }

    public void afterRefresh(boolean didRefresh) throws IOException {
        this.maps = new Maps(this.maps.current, ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency());
    }

    VersionValue getUnderLock(BytesRef uid) {
        Maps currentMaps = this.maps;
        VersionValue value = currentMaps.current.get(uid);
        if (value != null) {
            return value;
        }
        value = currentMaps.old.get(uid);
        if (value != null) {
            return value;
        }
        return this.tombstones.get(uid);
    }

    void putUnderLock(BytesRef uid, VersionValue version) {
        VersionValue prevTombstone;
        long uidRAMBytesUsed = BASE_BYTES_PER_BYTESREF + uid.bytes.length;
        VersionValue prev = this.maps.current.put(uid, version);
        if (prev != null) {
            long prevBytes = BASE_BYTES_PER_CHM_ENTRY;
            if (!prev.delete()) {
                prevBytes += prev.ramBytesUsed() + uidRAMBytesUsed;
            }
            this.ramBytesUsedCurrent.addAndGet(-prevBytes);
        }
        long newBytes = BASE_BYTES_PER_CHM_ENTRY;
        if (!version.delete()) {
            newBytes += version.ramBytesUsed() + uidRAMBytesUsed;
        }
        this.ramBytesUsedCurrent.addAndGet(newBytes);
        if (version.delete()) {
            prevTombstone = this.tombstones.put(uid, version);
            this.ramBytesUsedTombstones.addAndGet((long)BASE_BYTES_PER_CHM_ENTRY + version.ramBytesUsed() + uidRAMBytesUsed);
            if (prevTombstone == null && prev != null && prev.delete()) {
                this.ramBytesUsedCurrent.addAndGet(-(prev.ramBytesUsed() + uidRAMBytesUsed));
            }
        } else {
            prevTombstone = this.tombstones.remove(uid);
        }
        if (prevTombstone != null) {
            long v = this.ramBytesUsedTombstones.addAndGet(-((long)BASE_BYTES_PER_CHM_ENTRY + prevTombstone.ramBytesUsed() + uidRAMBytesUsed));
            assert (v >= 0L);
        }
    }

    void removeTombstoneUnderLock(BytesRef uid) {
        VersionValue curVersion;
        long uidRAMBytesUsed = BASE_BYTES_PER_BYTESREF + uid.bytes.length;
        VersionValue prev = this.tombstones.remove(uid);
        if (prev != null) {
            assert (prev.delete());
            long v = this.ramBytesUsedTombstones.addAndGet(-((long)BASE_BYTES_PER_CHM_ENTRY + prev.ramBytesUsed() + uidRAMBytesUsed));
            assert (v >= 0L);
        }
        if ((curVersion = this.maps.current.get(uid)) != null && curVersion.delete()) {
            this.ramBytesUsedCurrent.addAndGet(curVersion.ramBytesUsed() + uidRAMBytesUsed);
        }
    }

    VersionValue getTombstoneUnderLock(BytesRef uid) {
        return this.tombstones.get(uid);
    }

    Iterable<Map.Entry<BytesRef, VersionValue>> getAllTombstones() {
        return this.tombstones.entrySet();
    }

    synchronized void clear() {
        this.maps = new Maps();
        this.tombstones.clear();
        this.ramBytesUsedCurrent.set(0L);
        this.ramBytesUsedTombstones.set(0L);
        if (this.mgr != null) {
            this.mgr.removeListener((ReferenceManager.RefreshListener)this);
            this.mgr = null;
        }
    }

    public long ramBytesUsed() {
        return this.ramBytesUsedCurrent.get() + this.ramBytesUsedTombstones.get();
    }

    long ramBytesUsedForRefresh() {
        return this.ramBytesUsedCurrent.get();
    }

    private static class Maps {
        final Map<BytesRef, VersionValue> current;
        final Map<BytesRef, VersionValue> old;

        public Maps(Map<BytesRef, VersionValue> current, Map<BytesRef, VersionValue> old) {
            this.current = current;
            this.old = old;
        }

        public Maps() {
            this(ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency(), ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency());
        }
    }
}

