/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;

public abstract class AtomicGeoPointFieldData<Script extends ScriptDocValues>
implements AtomicFieldData<Script> {
    public abstract GeoPointValues getGeoPointValues();

    @Override
    public BytesValues getBytesValues() {
        final GeoPointValues values = this.getGeoPointValues();
        return new BytesValues(values.isMultiValued()){
            private final BytesRef scratch;
            {
                super(x0);
                this.scratch = new BytesRef();
            }

            @Override
            public int setDocument(int docId) {
                return values.setDocument(docId);
            }

            @Override
            public BytesRef nextValue() {
                GeoPoint value = values.nextValue();
                this.scratch.copyChars((CharSequence)GeoHashUtils.encode(value.lat(), value.lon()));
                return this.scratch;
            }
        };
    }
}

