/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.DoubleValuesComparatorBase;
import org.elasticsearch.search.MultiValueMode;

public final class DoubleValuesComparator
extends DoubleValuesComparatorBase<Double> {
    private final double[] values;

    public DoubleValuesComparator(IndexNumericFieldData<?> indexFieldData, double missingValue, int numHits, MultiValueMode sortMode) {
        super(indexFieldData, missingValue, sortMode);
        assert (indexFieldData.getNumericType().requiredBits() <= 64);
        this.values = new double[numHits];
    }

    public int compare(int slot1, int slot2) {
        double v1 = this.values[slot1];
        double v2 = this.values[slot2];
        return DoubleValuesComparator.compare(v1, v2);
    }

    public void setBottom(int slot) {
        this.bottom = this.values[slot];
    }

    public void copy(int slot, int doc) throws IOException {
        this.values[slot] = this.sortMode.getRelevantValue(this.readerValues, doc, this.missingValue);
    }

    public Double value(int slot) {
        return this.values[slot];
    }

    @Override
    public void add(int slot, int doc) {
        int n = slot;
        this.values[n] = this.values[n] + this.sortMode.getRelevantValue(this.readerValues, doc, this.missingValue);
    }

    @Override
    public void divide(int slot, int divisor) {
        int n = slot;
        this.values[n] = this.values[n] / (double)divisor;
    }

    @Override
    public void missing(int slot) {
        this.values[slot] = this.missingValue;
    }
}

