/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import org.apache.lucene.index.XOrdinalMap;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.elasticsearch.index.fielddata.BytesValues;

public class GlobalOrdinalMapping
extends BytesValues.WithOrdinals {
    private final BytesValues.WithOrdinals values;
    private final XOrdinalMap ordinalMap;
    private final LongValues mapping;
    private final BytesValues.WithOrdinals[] bytesValues;

    GlobalOrdinalMapping(XOrdinalMap ordinalMap, BytesValues.WithOrdinals[] bytesValues, int segmentIndex) {
        super(bytesValues[segmentIndex].isMultiValued());
        this.values = bytesValues[segmentIndex];
        this.bytesValues = bytesValues;
        this.ordinalMap = ordinalMap;
        this.mapping = ordinalMap.getGlobalOrds(segmentIndex);
    }

    @Override
    public long getMaxOrd() {
        return this.ordinalMap.getValueCount();
    }

    public long getGlobalOrd(long segmentOrd) {
        return this.mapping.get(segmentOrd);
    }

    @Override
    public long getOrd(int docId) {
        long v = this.values.getOrd(docId);
        if (v < 0L) {
            return v;
        }
        return this.getGlobalOrd(v);
    }

    @Override
    public long nextOrd() {
        return this.getGlobalOrd(this.values.nextOrd());
    }

    @Override
    public int setDocument(int docId) {
        return this.values.setDocument(docId);
    }

    @Override
    public BytesRef getValueByOrd(long globalOrd) {
        long segmentOrd = this.ordinalMap.getFirstSegmentOrd(globalOrd);
        int readerIndex = this.ordinalMap.getFirstSegmentNumber(globalOrd);
        return this.bytesValues[readerIndex].getValueByOrd(segmentOrd);
    }
}

