/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedSetDVBytesAtomicFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.indices.fielddata.breaker.CircuitBreakerService;
import org.elasticsearch.search.MultiValueMode;

public class SortedSetDVBytesIndexFieldData
extends DocValuesIndexFieldData
implements IndexFieldData.WithOrdinals<SortedSetDVBytesAtomicFieldData> {
    private final Settings indexSettings;
    private final IndexFieldDataCache cache;
    private final GlobalOrdinalsBuilder globalOrdinalsBuilder;
    private final CircuitBreakerService breakerService;

    public SortedSetDVBytesIndexFieldData(Index index, IndexFieldDataCache cache, Settings indexSettings, FieldMapper.Names fieldNames, GlobalOrdinalsBuilder globalOrdinalBuilder, CircuitBreakerService breakerService, FieldDataType fieldDataType) {
        super(index, fieldNames, fieldDataType);
        this.indexSettings = indexSettings;
        this.cache = cache;
        this.globalOrdinalsBuilder = globalOrdinalBuilder;
        this.breakerService = breakerService;
    }

    @Override
    public boolean valuesOrdered() {
        return true;
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(Object missingValue, MultiValueMode sortMode) {
        return new BytesRefFieldComparatorSource(this, missingValue, sortMode);
    }

    @Override
    public SortedSetDVBytesAtomicFieldData load(AtomicReaderContext context) {
        return new SortedSetDVBytesAtomicFieldData(context.reader(), this.fieldNames.indexName());
    }

    @Override
    public SortedSetDVBytesAtomicFieldData loadDirect(AtomicReaderContext context) throws Exception {
        return this.load(context);
    }

    @Override
    public IndexFieldData.WithOrdinals loadGlobal(IndexReader indexReader) {
        if (indexReader.leaves().size() <= 1) {
            return this;
        }
        try {
            return this.cache.load(indexReader, this);
        }
        catch (Throwable e) {
            if (e instanceof ElasticsearchException) {
                throw (ElasticsearchException)e;
            }
            throw new ElasticsearchException(e.getMessage(), e);
        }
    }

    @Override
    public IndexFieldData.WithOrdinals localGlobalDirect(IndexReader indexReader) throws Exception {
        return this.globalOrdinalsBuilder.build(indexReader, this, this.indexSettings, this.breakerService);
    }
}

