/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.percolator;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.fieldvisitor.JustSourceFieldsVisitor;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.percolator.PercolatorQueriesRegistry;

final class QueriesLoaderCollector
extends Collector {
    private final Map<BytesRef, Query> queries = Maps.newHashMap();
    private final JustSourceFieldsVisitor fieldsVisitor = new JustSourceFieldsVisitor();
    private final PercolatorQueriesRegistry percolator;
    private final IndexFieldData idFieldData;
    private final ESLogger logger;
    private BytesValues idValues;
    private AtomicReader reader;

    QueriesLoaderCollector(PercolatorQueriesRegistry percolator, ESLogger logger, MapperService mapperService, IndexFieldDataService indexFieldDataService) {
        this.percolator = percolator;
        this.logger = logger;
        FieldMapper idMapper = mapperService.smartNameFieldMapper("_id");
        this.idFieldData = indexFieldDataService.getForField(idMapper);
    }

    public Map<BytesRef, Query> queries() {
        return this.queries;
    }

    public void collect(int doc) throws IOException {
        if (this.idValues.setDocument(doc) > 0) {
            BytesRef id = this.idValues.nextValue();
            this.fieldsVisitor.reset();
            this.reader.document(doc, (StoredFieldVisitor)this.fieldsVisitor);
            try {
                Query parseQuery = this.percolator.parsePercolatorDocument(null, this.fieldsVisitor.source());
                if (parseQuery != null) {
                    this.queries.put(BytesRef.deepCopyOf((BytesRef)id), parseQuery);
                } else {
                    this.logger.warn("failed to add query [{}] - parser returned null", id);
                }
            }
            catch (Exception e) {
                this.logger.warn("failed to add query [{}]", e, id.utf8ToString());
            }
        }
    }

    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.reader = context.reader();
        this.idValues = this.idFieldData.load(context).getBytesValues();
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }
}

