/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.client.FilterClient;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;

public abstract class BaseRestHandler
extends AbstractComponent
implements RestHandler {
    private static String[] usefulHeaders = new String[0];
    private final Client client;

    public static synchronized void addUsefulHeaders(String ... headers) {
        String[] copy = new String[usefulHeaders.length + headers.length];
        System.arraycopy(usefulHeaders, 0, copy, 0, usefulHeaders.length);
        System.arraycopy(headers, 0, copy, usefulHeaders.length, headers.length);
        usefulHeaders = copy;
    }

    static String[] usefulHeaders() {
        String[] copy = new String[usefulHeaders.length];
        System.arraycopy(usefulHeaders, 0, copy, 0, usefulHeaders.length);
        return copy;
    }

    protected BaseRestHandler(Settings settings, Client client) {
        super(settings);
        this.client = client;
    }

    @Override
    public final void handleRequest(RestRequest request, RestChannel channel) throws Exception {
        this.handleRequest(request, channel, usefulHeaders.length == 0 ? this.client : new HeadersCopyClient(this.client, request, usefulHeaders));
    }

    protected abstract void handleRequest(RestRequest var1, RestChannel var2, Client var3) throws Exception;

    static final class HeadersCopyClient
    extends FilterClient {
        private final RestRequest restRequest;
        private final String[] usefulHeaders;
        private final IndicesAdmin indicesAdmin;
        private final ClusterAdmin clusterAdmin;

        HeadersCopyClient(Client in, RestRequest restRequest, String[] usefulHeaders) {
            super(in);
            this.restRequest = restRequest;
            this.usefulHeaders = usefulHeaders;
            this.indicesAdmin = new IndicesAdmin(in.admin().indices());
            this.clusterAdmin = new ClusterAdmin(in.admin().cluster());
        }

        private void copyHeaders(ActionRequest request) {
            for (String usefulHeader : this.usefulHeaders) {
                String headerValue = this.restRequest.header(usefulHeader);
                if (headerValue == null) continue;
                request.putHeader(usefulHeader, headerValue);
            }
        }

        @Override
        public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder, Client>> ActionFuture<Response> execute(Action<Request, Response, RequestBuilder, Client> action, Request request) {
            this.copyHeaders(request);
            return super.execute(action, request);
        }

        @Override
        public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder, Client>> void execute(Action<Request, Response, RequestBuilder, Client> action, Request request, ActionListener<Response> listener) {
            this.copyHeaders(request);
            super.execute(action, request, listener);
        }

        @Override
        public ClusterAdminClient cluster() {
            return this.clusterAdmin;
        }

        @Override
        public IndicesAdminClient indices() {
            return this.indicesAdmin;
        }

        private final class IndicesAdmin
        extends FilterClient.IndicesAdmin {
            private IndicesAdmin(IndicesAdminClient in) {
                super(in);
            }

            @Override
            public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder, IndicesAdminClient>> ActionFuture<Response> execute(Action<Request, Response, RequestBuilder, IndicesAdminClient> action, Request request) {
                HeadersCopyClient.this.copyHeaders(request);
                return super.execute(action, request);
            }

            @Override
            public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder, IndicesAdminClient>> void execute(Action<Request, Response, RequestBuilder, IndicesAdminClient> action, Request request, ActionListener<Response> listener) {
                HeadersCopyClient.this.copyHeaders(request);
                super.execute(action, request, listener);
            }
        }

        private final class ClusterAdmin
        extends FilterClient.ClusterAdmin {
            private ClusterAdmin(ClusterAdminClient in) {
                super(in);
            }

            @Override
            public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder, ClusterAdminClient>> ActionFuture<Response> execute(Action<Request, Response, RequestBuilder, ClusterAdminClient> action, Request request) {
                HeadersCopyClient.this.copyHeaders(request);
                return super.execute(action, request);
            }

            @Override
            public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder, ClusterAdminClient>> void execute(Action<Request, Response, RequestBuilder, ClusterAdminClient> action, Request request, ActionListener<Response> listener) {
                HeadersCopyClient.this.copyHeaders(request);
                super.execute(action, request, listener);
            }
        }
    }
}

