/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.rest.RestStatus;

public abstract class RestResponse {
    protected Map<String, List<String>> customHeaders;

    public abstract String contentType();

    public abstract boolean contentThreadSafe();

    public abstract BytesReference content();

    public abstract RestStatus status();

    public void addHeader(String name, String value) {
        List<String> header;
        if (this.customHeaders == null) {
            this.customHeaders = new HashMap<String, List<String>>(2);
        }
        if ((header = this.customHeaders.get(name)) == null) {
            header = new ArrayList<String>();
            this.customHeaders.put(name, header);
        }
        header.add(value);
    }

    @Nullable
    public Map<String, List<String>> getHeaders() {
        return this.customHeaders;
    }
}

