/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public abstract class BucketsAggregator
extends Aggregator {
    private IntArray docCounts;

    public BucketsAggregator(String name, Aggregator.BucketAggregationMode bucketAggregationMode, AggregatorFactories factories, long estimatedBucketsCount, AggregationContext context, Aggregator parent) {
        super(name, bucketAggregationMode, factories, estimatedBucketsCount, context, parent);
        this.docCounts = this.bigArrays.newIntArray(estimatedBucketsCount, true);
    }

    protected final long maxBucketOrd() {
        return this.docCounts.size();
    }

    protected final void collectBucket(int doc, long bucketOrd) throws IOException {
        this.docCounts = this.bigArrays.grow(this.docCounts, bucketOrd + 1L);
        this.collectExistingBucket(doc, bucketOrd);
    }

    protected final void collectExistingBucket(int doc, long bucketOrd) throws IOException {
        this.docCounts.increment(bucketOrd, 1);
        this.collectBucketNoCounts(doc, bucketOrd);
    }

    public IntArray getDocCounts() {
        return this.docCounts;
    }

    protected final void collectBucketNoCounts(int doc, long bucketOrd) throws IOException {
        this.collectableSubAggregators.collect(doc, bucketOrd);
    }

    protected final void incrementBucketDocCount(int inc, long bucketOrd) throws IOException {
        this.docCounts = this.bigArrays.grow(this.docCounts, bucketOrd + 1L);
        this.docCounts.increment(bucketOrd, inc);
    }

    public final int bucketDocCount(long bucketOrd) {
        if (bucketOrd >= this.docCounts.size()) {
            return 0;
        }
        return this.docCounts.get(bucketOrd);
    }

    protected final InternalAggregations bucketAggregations(long bucketOrd) {
        final ArrayList<InternalAggregation> childAggs = new ArrayList<InternalAggregation>();
        long bucketDocCount = this.bucketDocCount(bucketOrd);
        if (bucketDocCount == 0L) {
            for (int i = 0; i < this.subAggregators.length; ++i) {
                childAggs.add(this.subAggregators[i].buildEmptyAggregation());
            }
        } else {
            BucketCollector.BucketAnalysisCollector analysisCollector = new BucketCollector.BucketAnalysisCollector(){

                @Override
                public void add(Aggregation analysis) {
                    childAggs.add((InternalAggregation)analysis);
                }
            };
            this.collectableSubAggregators.gatherAnalysis(analysisCollector, bucketOrd);
            for (int i = 0; i < this.subAggregators.length; ++i) {
                if (this.subAggregators[i].shouldCollect()) continue;
                childAggs.add(this.subAggregators[i].buildAggregation(bucketOrd));
            }
        }
        return new InternalAggregations(childAggs);
    }

    protected final InternalAggregations bucketEmptyAggregations() {
        InternalAggregation[] aggregations = new InternalAggregation[this.subAggregators.length];
        for (int i = 0; i < this.subAggregators.length; ++i) {
            aggregations[i] = this.subAggregators[i].buildEmptyAggregation();
        }
        return new InternalAggregations(Arrays.asList(aggregations));
    }

    @Override
    public final void close() {
        try (IntArray releasable = this.docCounts;){
            super.close();
        }
    }
}

