/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.valuecount;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCount;

public class InternalValueCount
extends InternalNumericMetricsAggregation
implements ValueCount {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("value_count", "vcount");
    private static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalValueCount readResult(StreamInput in) throws IOException {
            InternalValueCount count = new InternalValueCount();
            count.readFrom(in);
            return count;
        }
    };
    private long value;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    InternalValueCount() {
    }

    public InternalValueCount(String name, long value) {
        super(name);
        this.value = value;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public InternalAggregation reduce(InternalAggregation.ReduceContext reduceContext) {
        long valueCount = 0L;
        for (InternalAggregation aggregation : reduceContext.aggregations()) {
            valueCount += ((InternalValueCount)aggregation).value;
        }
        return new InternalValueCount(this.name, valueCount);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.value = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeVLong(this.value);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject(this.name).field(InternalAggregation.CommonFields.VALUE, this.value).endObject();
    }

    public String toString() {
        return "count[" + this.value + "]";
    }
}

