/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support.values;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.aggregations.support.ScriptValues;

public class ScriptBytesValues
extends BytesValues
implements ScriptValues {
    private final BytesRef scratch = new BytesRef();
    final SearchScript script;
    private Iterator<?> iter;
    private Object value;

    public ScriptBytesValues(SearchScript script) {
        super(true);
        this.script = script;
    }

    @Override
    public SearchScript script() {
        return this.script;
    }

    @Override
    public int setDocument(int docId) {
        this.script.setNextDocId(docId);
        this.value = this.script.run();
        if (this.value == null) {
            this.iter = Iterators.emptyIterator();
            return 0;
        }
        if (this.value.getClass().isArray()) {
            final int length = Array.getLength(this.value);
            this.iter = new Iterator<Object>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < length;
                }

                @Override
                public Object next() {
                    return Array.get(ScriptBytesValues.this.value, this.i++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            return length;
        }
        if (this.value instanceof Collection) {
            Collection coll = (Collection)this.value;
            this.iter = coll.iterator();
            return coll.size();
        }
        this.iter = Iterators.singletonIterator(this.value);
        return 1;
    }

    @Override
    public BytesRef nextValue() {
        String next = this.iter.next().toString();
        this.scratch.copyChars((CharSequence)next);
        return this.scratch;
    }
}

