/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.search.suggest.SuggestUtils;
import org.elasticsearch.search.suggest.phrase.DirectCandidateGenerator;
import org.elasticsearch.search.suggest.phrase.WordScorer;

public final class LaplaceScorer
extends WordScorer {
    public static final WordScorer.WordScorerFactory FACTORY = new WordScorer.WordScorerFactory(){

        @Override
        public WordScorer newScorer(IndexReader reader, Terms terms, String field, double realWordLikelyhood, BytesRef separator) throws IOException {
            return new LaplaceScorer(reader, terms, field, realWordLikelyhood, separator, 0.5);
        }
    };
    private double alpha;

    public LaplaceScorer(IndexReader reader, Terms terms, String field, double realWordLikelyhood, BytesRef separator, double alpha) throws IOException {
        super(reader, terms, field, realWordLikelyhood, separator);
        this.alpha = alpha;
    }

    @Override
    protected double scoreBigram(DirectCandidateGenerator.Candidate word, DirectCandidateGenerator.Candidate w_1) throws IOException {
        SuggestUtils.join(this.separator, this.spare, w_1.term, word.term);
        return (this.alpha + (double)this.frequency(this.spare)) / (this.alpha + (double)w_1.frequency + (double)this.vocabluarySize);
    }

    @Override
    protected double scoreTrigram(DirectCandidateGenerator.Candidate word, DirectCandidateGenerator.Candidate w_1, DirectCandidateGenerator.Candidate w_2) throws IOException {
        SuggestUtils.join(this.separator, this.spare, w_2.term, w_1.term, word.term);
        long trigramCount = this.frequency(this.spare);
        SuggestUtils.join(this.separator, this.spare, w_1.term, word.term);
        return (this.alpha + (double)trigramCount) / (this.alpha + (double)this.frequency(this.spare) + (double)this.vocabluarySize);
    }
}

