/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner;

import fitnesse.testrunner.PageListSetUpTearDownSurrounder;
import fitnesse.testrunner.SuiteContentsFinder;
import fitnesse.testrunner.WikiPageIdentity;
import fitnesse.wiki.WikiPage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PagesByTestSystem {
    private final WikiPage root;
    private final Map<WikiPageIdentity, List<WikiPage>> pagesByTestSystem;

    public PagesByTestSystem(List<WikiPage> pages, WikiPage root) {
        this.root = root;
        this.pagesByTestSystem = this.addSuiteSetUpAndTearDownToAllTestSystems(this.mapWithAllPagesButSuiteSetUpAndTearDown(pages));
    }

    private Map<WikiPageIdentity, List<WikiPage>> mapWithAllPagesButSuiteSetUpAndTearDown(List<WikiPage> pages) {
        HashMap<WikiPageIdentity, List<WikiPage>> pagesByTestSystem = new HashMap<WikiPageIdentity, List<WikiPage>>(2);
        for (WikiPage wikiPage : pages) {
            if (SuiteContentsFinder.isSuiteSetupOrTearDown(wikiPage)) continue;
            WikiPageIdentity identity = new WikiPageIdentity(wikiPage);
            this.getOrMakeListWithinMap(pagesByTestSystem, identity).add(wikiPage);
        }
        return pagesByTestSystem;
    }

    private List<WikiPage> getOrMakeListWithinMap(Map<WikiPageIdentity, List<WikiPage>> pagesByTestSystem, WikiPageIdentity descriptor) {
        LinkedList<WikiPage> pagesForTestSystem;
        if (!pagesByTestSystem.containsKey(descriptor)) {
            pagesForTestSystem = new LinkedList();
            pagesByTestSystem.put(descriptor, pagesForTestSystem);
        } else {
            pagesForTestSystem = pagesByTestSystem.get(descriptor);
        }
        return pagesForTestSystem;
    }

    private Map<WikiPageIdentity, List<WikiPage>> addSuiteSetUpAndTearDownToAllTestSystems(Map<WikiPageIdentity, List<WikiPage>> pagesByTestSystem) {
        HashMap<WikiPageIdentity, List<WikiPage>> orderedPagesByTestSystem = new HashMap<WikiPageIdentity, List<WikiPage>>(pagesByTestSystem.size());
        if (pagesByTestSystem.size() > 0) {
            PageListSetUpTearDownSurrounder surrounder = new PageListSetUpTearDownSurrounder(this.root);
            for (Map.Entry<WikiPageIdentity, List<WikiPage>> pages : pagesByTestSystem.entrySet()) {
                orderedPagesByTestSystem.put(pages.getKey(), surrounder.surroundGroupsOfTestPagesWithRespectiveSetUpAndTearDowns(pages.getValue()));
            }
        }
        return orderedPagesByTestSystem;
    }

    public int totalTestsToRun() {
        int tests = 0;
        for (List<WikiPage> listOfPagesToRun : this.pagesByTestSystem.values()) {
            tests += listOfPagesToRun.size();
        }
        return tests;
    }

    public Collection<WikiPageIdentity> identities() {
        return this.pagesByTestSystem.keySet();
    }

    public List<WikiPage> testPagesForIdentity(WikiPageIdentity identity) {
        return Collections.unmodifiableList(this.pagesByTestSystem.get(identity));
    }
}

