/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.components.TraversalListener;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikitextPage;
import fitnesse.wikitext.parser.HtmlTranslator;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.Paths;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.WikiSourcePage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import util.Wildcard;

public class ClassPathBuilder {
    private List<String> allPaths;
    private StringBuilder pathsString;
    private Set<String> addedPaths;

    public String getClasspath(WikiPage page) {
        List<String> paths = this.getInheritedPathElements(page);
        return this.createClassPathString(paths, this.getPathSeparator(page));
    }

    public List<String> getInheritedPathElements(WikiPage page) {
        final ArrayList<String> items = new ArrayList<String>();
        page.getPageCrawler().traversePageAndAncestors((TraversalListener<? super WikiPage>)new TraversalListener<WikiPage>(){

            @Override
            public void process(WikiPage p) {
                items.addAll(ClassPathBuilder.this.getItemsFromPage(p));
            }
        });
        return items;
    }

    public String buildClassPath(List<WikiPage> testPages) {
        if (testPages.size() == 0) {
            return "";
        }
        String pathSeparator = this.getPathSeparator(testPages.get(0));
        ArrayList<String> classPathElements = new ArrayList<String>();
        for (WikiPage testPage : testPages) {
            this.addClassPathElements(testPage, classPathElements);
        }
        return this.createClassPathString(classPathElements, pathSeparator);
    }

    private void addClassPathElements(WikiPage page, List<String> classPathElements) {
        List<String> pathElements = this.getInheritedPathElements(page);
        classPathElements.addAll(pathElements);
    }

    public String getPathSeparator(WikiPage page) {
        String separator = page.getVariable("PATH_SEPARATOR");
        if (separator == null) {
            separator = System.getProperty("path.separator");
        }
        return separator;
    }

    public String createClassPathString(List<String> paths, String separator) {
        if (paths.isEmpty()) {
            return "defaultPath";
        }
        this.pathsString = new StringBuilder();
        paths = this.expandWildcards(paths);
        this.addedPaths = new HashSet<String>();
        for (String path : paths) {
            this.addPathToClassPathString(separator, path);
        }
        return this.pathsString.toString();
    }

    private void addPathToClassPathString(String separator, String path) {
        if (!this.addedPaths.contains(path)) {
            this.addedPaths.add(path);
            if (this.pathsString.length() > 0) {
                this.pathsString.append(separator);
            }
            this.pathsString.append(path);
        }
    }

    private List<String> expandWildcards(List<String> paths) {
        this.allPaths = new ArrayList<String>();
        for (String path : paths) {
            this.expandWildcards(path);
        }
        return this.allPaths;
    }

    private void expandWildcards(String path) {
        File file = new File(path);
        File dir = new File(file.getAbsolutePath()).getParentFile();
        if (this.isExpandableDoubleWildcard(path, dir)) {
            this.recursivelyAddMatchingFiles(path, dir);
        } else if (this.isExpandableSingleWildcard(path, dir)) {
            this.addMatchingFiles(path, dir);
        } else {
            this.allPaths.add(path);
        }
    }

    private void recursivelyAddMatchingFiles(String path, File dir) {
        String singleWildcardPath = this.convertDoubleToSingleWildcard(path);
        this.addMatchingSubfiles(singleWildcardPath, dir);
    }

    private boolean isExpandableSingleWildcard(String path, File dir) {
        return this.pathHasSingleWildcard(path) && dir.exists();
    }

    private boolean isExpandableDoubleWildcard(String path, File dir) {
        return this.pathHasDoubleWildCard(path) && dir.exists();
    }

    private boolean pathHasSingleWildcard(String path) {
        return path.indexOf(42) != -1;
    }

    private String convertDoubleToSingleWildcard(String path) {
        path = path.replaceFirst("\\*\\*", "*");
        return path;
    }

    private boolean pathHasDoubleWildCard(String path) {
        return path.contains("**");
    }

    private void addMatchingFiles(String path, File dir) {
        File[] files;
        String fileName = new File(path).getName();
        for (File file : files = dir.listFiles(new Wildcard(fileName))) {
            this.allPaths.add(file.getPath());
        }
    }

    private void addMatchingSubfiles(String path, File dir) {
        this.addMatchingFiles(path, dir);
        for (File file : dir.listFiles()) {
            if (!file.isDirectory()) continue;
            this.addMatchingSubfiles(path, file);
        }
    }

    protected List<String> getItemsFromPage(WikiPage page) {
        if (page instanceof WikitextPage) {
            Symbol tree = ((WikitextPage)((Object)page)).getSyntaxTree();
            ParsingPage parsingPage = ((WikitextPage)((Object)page)).getParsingPage();
            return new Paths(new HtmlTranslator(new WikiSourcePage(page), parsingPage)).getPaths(tree);
        }
        return Collections.emptyList();
    }
}

