/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.search;

import fitnesse.components.TraversalListener;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiWordReference;
import fitnesse.wiki.search.PageFinder;
import fitnesse.wikitext.parser.Alias;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.SymbolTreeWalker;
import fitnesse.wikitext.parser.WikiSourcePage;
import fitnesse.wikitext.parser.WikiWord;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class WhereUsedPageFinder
implements TraversalListener<WikiPage>,
PageFinder,
SymbolTreeWalker {
    private static final Logger LOG = Logger.getLogger(WhereUsedPageFinder.class.getName());
    private WikiPage subjectPage;
    private TraversalListener<? super WikiPage> observer;
    private WikiPage currentPage;
    private List<WikiPage> hits = new ArrayList<WikiPage>();

    public WhereUsedPageFinder(WikiPage subjectPage, TraversalListener<? super WikiPage> observer) {
        this.subjectPage = subjectPage;
        this.observer = observer;
    }

    @Override
    public void process(WikiPage currentPage) {
        this.currentPage = currentPage;
        String content = currentPage.getData().getContent();
        Symbol syntaxTree = Parser.make(new ParsingPage(new WikiSourcePage(currentPage), null), content, SymbolProvider.refactoringProvider).parse();
        syntaxTree.walkPreOrder(this);
    }

    @Override
    public void search(WikiPage page) {
        this.hits.clear();
        page.getPageCrawler().traverse(this);
    }

    @Override
    public boolean visit(Symbol node) {
        WikiPage referencedPage;
        if (this.hits.contains(this.currentPage)) {
            return true;
        }
        if (node.isType(WikiWord.symbolType) && (referencedPage = new WikiWordReference(this.currentPage, node.getContent()).getReferencedPage()) != null && referencedPage.equals(this.subjectPage)) {
            this.hits.add(this.currentPage);
            this.observer.process(this.currentPage);
        }
        if (node.isType(Alias.symbolType)) {
            WikiPage referencedPage2;
            String linkText = node.childAt(1).childAt(0).getContent();
            if (linkText.contains("?")) {
                linkText = linkText.substring(0, linkText.indexOf(63));
            }
            if ((referencedPage2 = new WikiWordReference(this.currentPage, linkText).getReferencedPage()) != null && referencedPage2.equals(this.subjectPage)) {
                this.hits.add(this.currentPage);
                this.observer.process(this.currentPage);
            }
        }
        return true;
    }

    @Override
    public boolean visitChildren(Symbol node) {
        return true;
    }
}

