/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.wiki.PageType;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import util.GracefulNamer;

public class ContentsItemBuilder {
    private Symbol contents;
    private int level;

    public ContentsItemBuilder(Symbol contents, int level) {
        this.contents = contents;
        this.level = level;
    }

    public HtmlTag buildLevel(SourcePage page) {
        HtmlTag list = new HtmlTag("ul");
        list.addAttribute("class", "toc" + this.level);
        for (SourcePage child : this.getSortedChildren(page)) {
            list.add(this.buildListItem(child));
        }
        return list;
    }

    private HtmlTag buildListItem(SourcePage child) {
        HtmlTag listItem = this.buildItem(child);
        if (child.getChildren().size() > 0) {
            if (this.level < this.getRecursionLimit()) {
                listItem.add(new ContentsItemBuilder(this.contents, this.level + 1).buildLevel(child));
            } else if (this.getRecursionLimit() > 0) {
                listItem.add(this.contents.getVariable("MORE_SUFFIX_TOC", " ..."));
            }
        }
        return listItem;
    }

    private Collection<SourcePage> getSortedChildren(SourcePage parent) {
        ArrayList<SourcePage> result = new ArrayList<SourcePage>(parent.getChildren());
        Collections.sort(result);
        return result;
    }

    public HtmlTag buildItem(SourcePage page) {
        HtmlTag listItem = new HtmlTag("li");
        HtmlTag link = new HtmlTag("a", this.buildBody(page));
        link.addAttribute("href", this.buildReference(page));
        link.addAttribute("class", this.getBooleanPropertiesClasses(page));
        listItem.add(link);
        String help = page.getProperty("Help");
        if (help.length() > 0) {
            if (this.hasOption("-h", "HELP_TOC")) {
                listItem.add(HtmlUtil.makeSpanTag("pageHelp", ": " + help));
            } else {
                link.addAttribute("title", help);
            }
        }
        return listItem;
    }

    private String buildBody(SourcePage page) {
        String filters;
        String properties;
        String itemText = page.getName();
        if (this.hasOption("-g", "REGRACE_TOC")) {
            itemText = GracefulNamer.regrace(itemText);
        }
        if (this.hasOption("-p", "PROPERTY_TOC") && (properties = this.getBooleanProperties(page)).length() > 0) {
            itemText = itemText + " " + properties;
        }
        if (this.hasOption("-f", "FILTER_TOC") && (filters = page.getProperty("Suites")).length() > 0) {
            itemText = itemText + " (" + filters + ")";
        }
        return itemText;
    }

    private String buildReference(SourcePage sourcePage) {
        return sourcePage.getFullName();
    }

    private int getRecursionLimit() {
        for (Symbol child : this.contents.getChildren()) {
            if (!child.getContent().startsWith("-R")) continue;
            String level = child.getContent().substring(2);
            if (level.length() == 0) {
                return Integer.MAX_VALUE;
            }
            try {
                return Integer.parseInt(level);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    private boolean hasOption(String option, String variableName) {
        for (Symbol child : this.contents.getChildren()) {
            if (!child.getContent().equals(option)) continue;
            return true;
        }
        return variableName.length() > 0 && this.contents.getVariable(variableName, "").equals("true");
    }

    private String getBooleanProperties(SourcePage sourcePage) {
        String result = "";
        if (sourcePage.hasProperty(PageType.SUITE.toString())) {
            result = result + "*";
        }
        if (sourcePage.hasProperty(PageType.TEST.toString())) {
            result = result + "+";
        }
        if (sourcePage.hasProperty("WikiImport")) {
            result = result + "@";
        }
        if (sourcePage.hasProperty("Prune")) {
            result = result + "-";
        }
        return result;
    }

    private String getBooleanPropertiesClasses(SourcePage sourcePage) {
        String result = "";
        result = sourcePage.hasProperty(PageType.SUITE.toString()) ? result + "suite" : (sourcePage.hasProperty(PageType.TEST.toString()) ? result + "test" : result + "static");
        if (sourcePage.hasProperty("WikiImport")) {
            result = result + " linked";
        }
        if (sourcePage.hasProperty("Prune")) {
            result = result + " pruned";
        }
        return result;
    }
}

