/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Link;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import java.util.Map;
import java.util.TreeMap;
import util.Maybe;

public class Image
extends SymbolType
implements Rule {
    public static final Image symbolType = new Image();

    public Image() {
        super("Image");
        this.wikiMatcher(new Matcher().string("!img-l"));
        this.wikiMatcher(new Matcher().string("!img-r"));
        this.wikiMatcher(new Matcher().string("!img"));
        this.wikiRule(this);
    }

    @Override
    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        String imageProperty = current.getContent().endsWith("l") ? "left" : (current.getContent().endsWith("r") ? "right" : "");
        parser.moveNext(1);
        if (!parser.getCurrent().isType(SymbolType.Whitespace)) {
            return Symbol.nothing;
        }
        parser.moveNext(1);
        TreeMap<String, String> options = new TreeMap<String, String>();
        while (parser.getCurrent().isType(SymbolType.Text) && parser.getCurrent().getContent().startsWith("-")) {
            String option = parser.getCurrent().getContent();
            parser.moveNext(1);
            if (!parser.getCurrent().isType(SymbolType.Whitespace)) {
                return Symbol.nothing;
            }
            parser.moveNext(1);
            if (!parser.getCurrent().isType(SymbolType.Text)) {
                return Symbol.nothing;
            }
            String value = parser.getCurrent().getContent();
            parser.moveNext(1);
            if (!parser.getCurrent().isType(SymbolType.Whitespace)) {
                return Symbol.nothing;
            }
            parser.moveNext(1);
            options.put(option, value);
        }
        if (parser.getCurrent().isType(Link.symbolType)) {
            Maybe<Symbol> link = Link.symbolType.getWikiRule().parse(parser.getCurrent(), parser);
            if (link.isNothing()) {
                return Symbol.nothing;
            }
            this.addOptions(link.getValue(), options);
            return this.makeImageLink(link.getValue(), imageProperty);
        }
        if (parser.getCurrent().isType(SymbolType.Text)) {
            Symbol list = new Symbol(SymbolType.SymbolList).add(parser.getCurrent());
            Symbol link = new Symbol(Link.symbolType).add(list);
            this.addOptions(link, options);
            return this.makeImageLink(link, imageProperty);
        }
        return Symbol.nothing;
    }

    private void addOptions(Symbol link, Map<String, String> options) {
        for (String key : options.keySet()) {
            if (key.equals("-w")) {
                link.putProperty("width", options.get(key));
            }
            if (key.equals("-m")) {
                link.putProperty("style", String.format("%2$smargin:%1$spx %1$spx %1$spx %1$spx;", options.get(key), link.getProperty("style")));
            }
            if (!key.equals("-b")) continue;
            link.putProperty("style", String.format("%2$sborder:%1$spx solid black;", options.get(key), link.getProperty("style")));
        }
    }

    private Maybe<Symbol> makeImageLink(Symbol link, String imageProperty) {
        return new Maybe<Symbol>(link.putProperty("image", imageProperty));
    }
}

