/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchRefUpdate {
    private final RefDatabase refdb;
    private final List<ReceiveCommand> commands;
    private boolean allowNonFastForwards;
    private PersonIdent refLogIdent;
    private String refLogMessage;
    private boolean refLogIncludeResult;

    protected BatchRefUpdate(RefDatabase refdb) {
        this.refdb = refdb;
        this.commands = new ArrayList<ReceiveCommand>();
    }

    public boolean isAllowNonFastForwards() {
        return this.allowNonFastForwards;
    }

    public BatchRefUpdate setAllowNonFastForwards(boolean allow) {
        this.allowNonFastForwards = allow;
        return this;
    }

    public PersonIdent getRefLogIdent() {
        return this.refLogIdent;
    }

    public BatchRefUpdate setRefLogIdent(PersonIdent pi) {
        this.refLogIdent = pi;
        return this;
    }

    public String getRefLogMessage() {
        return this.refLogMessage;
    }

    public boolean isRefLogIncludingResult() {
        return this.refLogIncludeResult;
    }

    public BatchRefUpdate setRefLogMessage(String msg, boolean appendStatus) {
        if (msg == null && !appendStatus) {
            this.disableRefLog();
        } else if (msg == null && appendStatus) {
            this.refLogMessage = "";
            this.refLogIncludeResult = true;
        } else {
            this.refLogMessage = msg;
            this.refLogIncludeResult = appendStatus;
        }
        return this;
    }

    public BatchRefUpdate disableRefLog() {
        this.refLogMessage = null;
        this.refLogIncludeResult = false;
        return this;
    }

    public boolean isRefLogDisabled() {
        return this.refLogMessage == null;
    }

    public List<ReceiveCommand> getCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public BatchRefUpdate addCommand(ReceiveCommand cmd) {
        this.commands.add(cmd);
        return this;
    }

    public BatchRefUpdate addCommand(ReceiveCommand ... cmd) {
        return this.addCommand(Arrays.asList(cmd));
    }

    public BatchRefUpdate addCommand(Collection<ReceiveCommand> cmd) {
        this.commands.addAll(cmd);
        return this;
    }

    public void execute(RevWalk walk, ProgressMonitor update) throws IOException {
        update.beginTask(JGitText.get().updatingReferences, this.commands.size());
        block6: for (ReceiveCommand cmd : this.commands) {
            try {
                update.update(1);
                if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                cmd.updateType(walk);
                RefUpdate ru = this.newUpdate(cmd);
                switch (cmd.getType()) {
                    case DELETE: {
                        cmd.setResult(ru.delete(walk));
                        continue block6;
                    }
                    case CREATE: 
                    case UPDATE: 
                    case UPDATE_NONFASTFORWARD: {
                        cmd.setResult(ru.update(walk));
                        continue block6;
                    }
                }
            }
            catch (IOException err) {
                cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, MessageFormat.format(JGitText.get().lockError, err.getMessage()));
            }
        }
        update.endTask();
    }

    protected RefUpdate newUpdate(ReceiveCommand cmd) throws IOException {
        RefUpdate ru = this.refdb.newUpdate(cmd.getRefName(), false);
        if (this.isRefLogDisabled()) {
            ru.disableRefLog();
        } else {
            ru.setRefLogIdent(this.refLogIdent);
            ru.setRefLogMessage(this.refLogMessage, this.refLogIncludeResult);
        }
        switch (cmd.getType()) {
            case DELETE: {
                if (!ObjectId.zeroId().equals(cmd.getOldId())) {
                    ru.setExpectedOldObjectId(cmd.getOldId());
                }
                ru.setForceUpdate(true);
                return ru;
            }
        }
        ru.setForceUpdate(this.isAllowNonFastForwards());
        ru.setExpectedOldObjectId(cmd.getOldId());
        ru.setNewObjectId(cmd.getNewId());
        return ru;
    }
}

