/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FakeScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

final class BooleanScorer
extends BulkScorer {
    private SubScorer scorers = null;
    private BucketTable bucketTable = new BucketTable();
    private final float[] coordFactors;
    private final int minNrShouldMatch;
    private int end;
    private Bucket current;
    private static final int PROHIBITED_MASK = 1;
    private final Weight weight;

    BooleanScorer(BooleanQuery.BooleanWeight weight, boolean disableCoord, int minNrShouldMatch, List<BulkScorer> optionalScorers, List<BulkScorer> prohibitedScorers, int maxCoord) throws IOException {
        this.minNrShouldMatch = minNrShouldMatch;
        this.weight = weight;
        for (BulkScorer scorer : optionalScorers) {
            this.scorers = new SubScorer(scorer, false, false, this.bucketTable.newCollector(0), this.scorers);
        }
        for (BulkScorer scorer : prohibitedScorers) {
            this.scorers = new SubScorer(scorer, false, true, this.bucketTable.newCollector(1), this.scorers);
        }
        this.coordFactors = new float[optionalScorers.size() + 1];
        for (int i = 0; i < this.coordFactors.length; ++i) {
            this.coordFactors[i] = disableCoord ? 1.0f : weight.coord(i, maxCoord);
        }
    }

    @Override
    public boolean score(Collector collector, int max) throws IOException {
        boolean more;
        FakeScorer fs = new FakeScorer();
        collector.setScorer(fs);
        do {
            this.bucketTable.first = null;
            while (this.current != null) {
                if ((this.current.bits & 1) == 0) {
                    if (this.current.doc >= max) {
                        Bucket tmp = this.current;
                        this.current = this.current.next;
                        tmp.next = this.bucketTable.first;
                        this.bucketTable.first = tmp;
                        continue;
                    }
                    if (this.current.coord >= this.minNrShouldMatch) {
                        fs.score = (float)(this.current.score * (double)this.coordFactors[this.current.coord]);
                        fs.doc = this.current.doc;
                        fs.freq = this.current.coord;
                        collector.collect(this.current.doc);
                    }
                }
                this.current = this.current.next;
            }
            if (this.bucketTable.first != null) {
                this.current = this.bucketTable.first;
                this.bucketTable.first = this.current.next;
                return true;
            }
            more = false;
            this.end += 2048;
            SubScorer sub = this.scorers;
            while (sub != null) {
                if (sub.more) {
                    sub.more = sub.scorer.score(sub.collector, this.end);
                    more |= sub.more;
                }
                sub = sub.next;
            }
            this.current = this.bucketTable.first;
        } while (this.current != null || more);
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("boolean(");
        SubScorer sub = this.scorers;
        while (sub != null) {
            buffer.append(sub.scorer.toString());
            buffer.append(" ");
            sub = sub.next;
        }
        buffer.append(")");
        return buffer.toString();
    }

    static final class SubScorer {
        public BulkScorer scorer;
        public boolean prohibited;
        public Collector collector;
        public SubScorer next;
        public boolean more;

        public SubScorer(BulkScorer scorer, boolean required, boolean prohibited, Collector collector, SubScorer next) {
            if (required) {
                throw new IllegalArgumentException("this scorer cannot handle required=true");
            }
            this.scorer = scorer;
            this.more = true;
            this.prohibited = prohibited;
            this.collector = collector;
            this.next = next;
        }
    }

    static final class BucketTable {
        public static final int SIZE = 2048;
        public static final int MASK = 2047;
        final Bucket[] buckets = new Bucket[2048];
        Bucket first = null;

        public BucketTable() {
            for (int idx = 0; idx < 2048; ++idx) {
                this.buckets[idx] = new Bucket();
            }
        }

        public Collector newCollector(int mask) {
            return new BooleanScorerCollector(mask, this);
        }

        public int size() {
            return 2048;
        }
    }

    static final class Bucket {
        int doc = -1;
        double score;
        int bits;
        int coord;
        Bucket next;

        Bucket() {
        }
    }

    private static final class BooleanScorerCollector
    extends Collector {
        private BucketTable bucketTable;
        private int mask;
        private Scorer scorer;

        public BooleanScorerCollector(int mask, BucketTable bucketTable) {
            this.mask = mask;
            this.bucketTable = bucketTable;
        }

        @Override
        public void collect(int doc) throws IOException {
            BucketTable table = this.bucketTable;
            int i = doc & 0x7FF;
            Bucket bucket = table.buckets[i];
            if (bucket.doc != doc) {
                bucket.doc = doc;
                bucket.score = this.scorer.score();
                bucket.bits = this.mask;
                bucket.coord = 1;
                bucket.next = table.first;
                table.first = bucket;
            } else {
                bucket.score += (double)this.scorer.score();
                bucket.bits |= this.mask;
                ++bucket.coord;
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext context) {
        }

        @Override
        public void setScorer(Scorer scorer) {
            this.scorer = scorer;
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }
}

