/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Locale;

public enum Version {
    LUCENE_3_0,
    LUCENE_3_1,
    LUCENE_3_2,
    LUCENE_3_3,
    LUCENE_3_4,
    LUCENE_3_5,
    LUCENE_3_6,
    LUCENE_4_0,
    LUCENE_4_1,
    LUCENE_4_2,
    LUCENE_4_3,
    LUCENE_4_4,
    LUCENE_4_5,
    LUCENE_4_6,
    LUCENE_4_7,
    LUCENE_4_8,
    LUCENE_4_9,
    LUCENE_CURRENT;

    @Deprecated
    public static final Version LUCENE_30;
    @Deprecated
    public static final Version LUCENE_31;
    @Deprecated
    public static final Version LUCENE_32;
    @Deprecated
    public static final Version LUCENE_33;
    @Deprecated
    public static final Version LUCENE_34;
    @Deprecated
    public static final Version LUCENE_35;
    @Deprecated
    public static final Version LUCENE_36;
    @Deprecated
    public static final Version LUCENE_40;
    @Deprecated
    public static final Version LUCENE_41;
    @Deprecated
    public static final Version LUCENE_42;
    @Deprecated
    public static final Version LUCENE_43;
    @Deprecated
    public static final Version LUCENE_44;
    @Deprecated
    public static final Version LUCENE_45;
    @Deprecated
    public static final Version LUCENE_46;
    @Deprecated
    public static final Version LUCENE_47;
    @Deprecated
    public static final Version LUCENE_48;

    public boolean onOrAfter(Version other) {
        return this.compareTo(other) >= 0;
    }

    public static Version parseLeniently(String version) {
        String parsedMatchVersion = version.toUpperCase(Locale.ROOT).replaceFirst("^(\\d+)\\.(\\d+)$", "LUCENE_$1_$2").replaceFirst("^LUCENE_(\\d)(\\d)$", "LUCENE_$1_$2");
        return Version.valueOf(parsedMatchVersion);
    }

    static {
        LUCENE_30 = LUCENE_3_0;
        LUCENE_31 = LUCENE_3_1;
        LUCENE_32 = LUCENE_3_2;
        LUCENE_33 = LUCENE_3_3;
        LUCENE_34 = LUCENE_3_4;
        LUCENE_35 = LUCENE_3_5;
        LUCENE_36 = LUCENE_3_6;
        LUCENE_40 = LUCENE_4_0;
        LUCENE_41 = LUCENE_4_1;
        LUCENE_42 = LUCENE_4_2;
        LUCENE_43 = LUCENE_4_3;
        LUCENE_44 = LUCENE_4_4;
        LUCENE_45 = LUCENE_4_5;
        LUCENE_46 = LUCENE_4_6;
        LUCENE_47 = LUCENE_4_7;
        LUCENE_48 = LUCENE_4_8;
    }
}

