/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.spi.event.CiCopiedEvent;
import com.xebialabs.deployit.engine.spi.event.CiMovedEvent;
import com.xebialabs.deployit.engine.spi.event.CiRenamedEvent;
import com.xebialabs.deployit.engine.spi.event.CisCreatedEvent;
import com.xebialabs.deployit.engine.spi.event.CisDeletedEvent;
import com.xebialabs.deployit.engine.spi.event.CisUpdatedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.repository.JcrChangeSetExecutor;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.JcrQueryTemplate;
import com.xebialabs.deployit.repository.JcrReferentialIntegrityChecker;
import com.xebialabs.deployit.repository.NodeReader;
import com.xebialabs.deployit.repository.NodeReaderContext;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.SearchQueryBuilder;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.util.PasswordEncrypter;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class JcrRepositoryService
implements RepositoryService {
    private final JcrTemplate jcrTemplate;
    private final PasswordEncrypter passwordEncrypter;
    private static Logger logger = LoggerFactory.getLogger(JcrRepositoryService.class);

    @Autowired
    public JcrRepositoryService(JcrTemplate jcrTemplate, PasswordEncrypter passwordEncrypter) {
        this.jcrTemplate = jcrTemplate;
        this.passwordEncrypter = passwordEncrypter;
    }

    @Override
    public boolean exists(final String id) {
        logger.debug("Checking whether node [{}] exists.", (Object)id);
        return this.jcrTemplate.execute(new JcrCallback<Boolean>(){

            @Override
            public Boolean doInJcr(Session session) throws RepositoryException {
                return session.itemExists(JcrPathHelper.getAbsolutePathFromId(id));
            }
        });
    }

    @Override
    public <T extends ConfigurationItem> T read(String id) {
        return this.read(id, Integer.MAX_VALUE, null, true);
    }

    @Override
    public <T extends ConfigurationItem> T read(String id, int depth) {
        return this.read(id, depth, null, true);
    }

    @Override
    public <T extends ConfigurationItem> T read(String id, WorkDir workDir) {
        return this.read(id, Integer.MAX_VALUE, workDir, true);
    }

    @Override
    public <T extends ConfigurationItem> T read(String id, boolean useCache) {
        return this.read(id, Integer.MAX_VALUE, null, useCache);
    }

    @Override
    public <T extends ConfigurationItem> T read(String id, WorkDir workDir, boolean useCache) {
        return this.read(id, Integer.MAX_VALUE, workDir, useCache);
    }

    @Override
    public <T extends ConfigurationItem> T read(final String id, final int depth, final WorkDir workDir, final boolean useCache) {
        logger.debug("Reading node [{}] with depth {} and workdir {} (useCache={})", new Object[]{id, depth, workDir, useCache});
        Preconditions.checkNotNull((Object)id, (Object)"id is null");
        return (T)((ConfigurationItem)this.jcrTemplate.execute(new JcrCallback<T>(){

            @Override
            public T doInJcr(Session session) throws RepositoryException {
                try {
                    Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(id));
                    if (useCache) {
                        return NodeReader.read(session, node, depth, workDir, JcrRepositoryService.this.passwordEncrypter);
                    }
                    return NodeReader.read(session, node, depth, workDir, new NodeReaderContext(), JcrRepositoryService.this.passwordEncrypter);
                }
                catch (PathNotFoundException exc) {
                    throw new NotFoundException("Repository entity [%s] not found", id);
                }
            }
        }));
    }

    @Override
    public List<ConfigurationItemData> list(SearchParameters parameters) {
        Preconditions.checkNotNull((Object)((Object)parameters), (Object)"parameters is null");
        logger.debug("Listing node IDs with parameters {}.", (Object)parameters);
        JcrQueryTemplate queryTemplate = new SearchQueryBuilder(parameters).createTemplate();
        return this.list(queryTemplate);
    }

    @Override
    public <T extends ConfigurationItem> List<T> listEntities(SearchParameters parameters) {
        Preconditions.checkNotNull((Object)((Object)parameters), (Object)"parameters is null");
        logger.debug("Listing nodes with parameters {}.", (Object)parameters);
        JcrQueryTemplate queryTemplate = new SearchQueryBuilder(parameters).createTemplate();
        return this.listEntities(queryTemplate);
    }

    @Override
    public List<ConfigurationItemData> list(JcrQueryTemplate queryTemplate) {
        Preconditions.checkNotNull((Object)queryTemplate, (Object)"queryTemplate is null");
        logger.debug("Listing node IDs with JCR query template {}.", (Object)queryTemplate);
        List entities = this.listEntities(queryTemplate);
        return Lists.transform(entities, (Function)new Function<ConfigurationItem, ConfigurationItemData>(){

            public ConfigurationItemData apply(ConfigurationItem input) {
                return new ConfigurationItemData(input.getId(), input.getType());
            }
        });
    }

    @Override
    public <T extends ConfigurationItem> List<T> listEntities(final JcrQueryTemplate queryTemplate) {
        Preconditions.checkNotNull((Object)queryTemplate, (Object)"query is null");
        logger.debug("Listing nodes with JCR query template {}.", (Object)queryTemplate);
        return (List)this.jcrTemplate.execute(new JcrCallback<List<T>>(){

            @Override
            public List<T> doInJcr(Session session) throws RepositoryException {
                Query query = queryTemplate.createQuery(session);
                QueryResult queryResult = query.execute();
                return JcrRepositoryService.this.getOrderedEntities(session, queryResult, queryTemplate.depth);
            }
        });
    }

    private <T extends ConfigurationItem> List<T> getOrderedEntities(Session session, QueryResult queryResult, int depth) throws RepositoryException {
        ArrayList items = Lists.newArrayList();
        RowIterator iterator = queryResult.getRows();
        while (iterator.hasNext()) {
            Node node = iterator.nextRow().getNode("ci");
            Object item = NodeReader.read(session, node, depth, null, this.passwordEncrypter);
            items.add(item);
        }
        return items;
    }

    @Override
    public <T extends ConfigurationItem> void create(T ... cis) {
        ChangeSet changeset = new ChangeSet();
        changeset.create(Lists.newArrayList((Object[])cis));
        this.execute(changeset);
        EventBusHolder.publish(new CisCreatedEvent(cis));
    }

    @Override
    public <T extends ConfigurationItem> void update(T ... cis) {
        ChangeSet changeset = new ChangeSet();
        changeset.update(Lists.newArrayList((Object[])cis));
        this.execute(changeset);
        EventBusHolder.publish(new CisUpdatedEvent(changeset.getUpdateCis()));
    }

    @Override
    public <T extends ConfigurationItem> void createOrUpdate(T ... cis) {
        ChangeSet changeSet = new ChangeSet();
        changeSet.createOrUpdate(Lists.newArrayList((Object[])cis));
        this.execute(changeSet);
        EventBusHolder.publish(new CisCreatedEvent(Lists.newArrayList(changeSet.getCreateOrUpdateActualCreatedCis())));
        EventBusHolder.publish(new CisUpdatedEvent((List)Lists.newArrayList(changeSet.getCreateOrUpdateActualUpdatedCis())));
    }

    @Override
    public void delete(String ... ids) {
        ChangeSet changeset = new ChangeSet();
        changeset.delete(Lists.newArrayList((Object[])ids));
        this.checkReferentialIntegrity(changeset);
        this.execute(changeset);
        EventBusHolder.publish(new CisDeletedEvent(ids));
    }

    @Override
    public void rename(String id, String newName) {
        Checks.checkArgument(newName.indexOf(47) == -1, "New name [%s] should not contain a /", newName);
        ChangeSet changeSet = new ChangeSet();
        changeSet.rename(id, newName);
        this.execute(changeSet);
        EventBusHolder.publish(new CiRenamedEvent(id, newName));
    }

    @Override
    public <T extends ConfigurationItem> void move(String id, String newId) {
        logger.debug("Moving node [{}] to [{}]", (Object)id, (Object)newId);
        ChangeSet changeSet = new ChangeSet();
        changeSet.move(id, newId);
        this.execute(changeSet);
        EventBusHolder.publish(new CiMovedEvent(id, newId));
    }

    protected void checkMoveAllowed(Type type) {
    }

    @Override
    public <T extends ConfigurationItem> void copy(String id, String newId) {
        ChangeSet changeSet = new ChangeSet();
        changeSet.copy(id, newId);
        this.execute(changeSet);
        EventBusHolder.publish(new CiCopiedEvent(id, newId));
    }

    protected void checkCopyAllowed(Session session, String toBeCopied, String newId) throws RepositoryException {
    }

    static Type readType(Session session, String id) throws RepositoryException {
        return Type.valueOf((String)session.getNode(JcrPathHelper.getAbsolutePathFromId(id)).getProperty("$configuration.item.type").getString());
    }

    static String extractParentId(String id) {
        int indexOf = id.lastIndexOf(47);
        if (indexOf != -1) {
            return id.substring(0, indexOf);
        }
        return id;
    }

    @Override
    public void execute(ChangeSet changeset) {
        this.jcrTemplate.execute(new JcrChangeSetExecutor(this, changeset, this.passwordEncrypter));
    }

    @Override
    public void checkReferentialIntegrity(ChangeSet changeset) throws ItemInUseException, ItemAlreadyExistsException {
        this.jcrTemplate.execute(new JcrReferentialIntegrityChecker(this, changeset, this.passwordEncrypter));
    }
}

