/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.service;

import com.xebialabs.license.InvalidLicenseException;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.LicenseReader;
import com.xebialabs.license.UnableToValidateLicenseException;
import com.xebialabs.license.service.LicenseService;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseServiceImpl
implements LicenseService {
    private static final Logger log = LoggerFactory.getLogger(LicenseServiceImpl.class);
    private File licenseFile;
    private License license;
    private final String product;

    @Override
    public boolean isLicenseExpired() {
        if (this.license != null && !this.license.isDateExpired()) {
            return false;
        }
        this.readLicense();
        return this.license == null || this.license.isDateExpired();
    }

    @Override
    public License getLicense() {
        return this.license;
    }

    public LicenseServiceImpl(String licenseFileName, String product) throws IOException {
        this.product = product;
        this.licenseFile = new File(licenseFileName);
        if (this.isLicenseExpired()) {
            log.warn("*** Please contact your XebiaLabs sales representative to obtain a valid license.");
            log.warn("*** Place a valid license in {} to continue using the product.", (Object)this.licenseFile.getAbsolutePath());
        }
    }

    private void readLicense() {
        String licenseFilePath = this.licenseFile.getAbsolutePath();
        if (!this.licenseFile.exists()) {
            log.warn("*** License file {} not found.", (Object)licenseFilePath);
            return;
        }
        try {
            log.info("Reading license from file {}", (Object)licenseFilePath);
            License readLicense = LicenseReader.readLicense((File)this.licenseFile);
            log.info("Product                : {}", (Object)readLicense.getStringValue(LicenseProperty.PRODUCT));
            log.info("Licensed to            : {}", (Object)readLicense.getStringValue(LicenseProperty.LICENSED_TO));
            log.info("License contact        : {}", (Object)readLicense.getStringValue(LicenseProperty.CONTACT));
            if (readLicense.hasLicenseProperty(LicenseProperty.REPOSITORY_ID)) {
                log.info("Repository Id          : {}", (Object)readLicense.getStringValue(LicenseProperty.REPOSITORY_ID));
            }
            log.info("License expires after  : {}", (Object)readLicense.getStringValue(LicenseProperty.EXPIRES_AFTER));
            if (readLicense.hasLicenseProperty(LicenseProperty.MAX_NUMBER_OF_USERS)) {
                log.info("Maximum number of users: {}", (Object)readLicense.getStringValue(LicenseProperty.MAX_NUMBER_OF_USERS));
            }
            if (readLicense.hasLicenseProperty(LicenseProperty.MAX_NUMBER_OF_CIS)) {
                log.info("Maximum number of configuration items: {}", (Object)readLicense.getStringValue(LicenseProperty.MAX_NUMBER_OF_CIS));
            }
            if (readLicense.hasLicenseProperty(LicenseProperty.LICENSED_PLUGINS)) {
                log.info("Licensed plugins: {}", (Object)readLicense.getStringValue(LicenseProperty.LICENSED_PLUGINS));
            }
            if (readLicense.hasLicenseProperty(LicenseProperty.SUPPORT_POLICY)) {
                log.info("Support policy: {}", (Object)readLicense.getStringValue(LicenseProperty.SUPPORT_POLICY));
            }
            if (!readLicense.getStringValue(LicenseProperty.PRODUCT).equals(this.product)) {
                log.warn("*** License is not for " + this.product);
                return;
            }
            this.license = readLicense;
        }
        catch (InvalidLicenseException ex) {
            log.warn("*** License is invalid: {}", (Object)ex.getMessage());
            return;
        }
        catch (UnableToValidateLicenseException ex) {
            log.warn("*** License could not be validated.", (Object)licenseFilePath);
            log.warn(ex.getMessage(), (Throwable)ex);
            return;
        }
        if (this.license.isDateExpired()) {
            log.warn("*** License has expired.");
        }
    }
}

