/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class XLTestManifest {
    private final String manifestVersion;
    private final String name;
    private final String vendor;
    private final String version;
    private final String build;

    public XLTestManifest() {
        this(XLTestManifest.class);
    }

    public XLTestManifest(Class clazz) {
        Manifest manifest;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            this.build = "DEVELOP";
            this.version = "DEVELOP";
            this.vendor = "DEVELOP";
            this.name = "DEVELOP";
            this.manifestVersion = "DEVELOP";
            return;
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try {
            InputStream inputStream = new URL(manifestPath).openStream();
            manifest = new Manifest(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Can not find XL Test application information", e);
        }
        Attributes attr = manifest.getMainAttributes();
        this.manifestVersion = attr.getValue("Manifest-Version");
        this.build = attr.getValue("Implementation-Version");
        this.name = attr.getValue("Specification-Title");
        this.version = attr.getValue("Specification-Version");
        this.vendor = attr.getValue("Specification-Vendor");
    }

    public String getManifestVersion() {
        return this.manifestVersion;
    }

    public String getBuild() {
        return this.build;
    }

    public String getName() {
        return this.name;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getVersion() {
        return this.version;
    }
}

