/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;

public class SimpleFSDirectory
extends FSDirectory {
    public SimpleFSDirectory(File path, LockFactory lockFactory) throws IOException {
        super(path, lockFactory);
    }

    public SimpleFSDirectory(File path) throws IOException {
        super(path, null);
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        File path = new File(this.directory, name);
        RandomAccessFile raf = new RandomAccessFile(path, "r");
        return new SimpleFSIndexInput("SimpleFSIndexInput(path=\"" + path.getPath() + "\")", raf, context);
    }

    static final class SimpleFSIndexInput
    extends BufferedIndexInput {
        private static final int CHUNK_SIZE = 8192;
        protected final RandomAccessFile file;
        boolean isClone = false;
        protected final long off;
        protected final long end;

        public SimpleFSIndexInput(String resourceDesc, RandomAccessFile file, IOContext context) throws IOException {
            super(resourceDesc, context);
            this.file = file;
            this.off = 0L;
            this.end = file.length();
        }

        public SimpleFSIndexInput(String resourceDesc, RandomAccessFile file, long off, long length, int bufferSize) {
            super(resourceDesc, bufferSize);
            this.file = file;
            this.off = off;
            this.end = off + length;
            this.isClone = true;
        }

        @Override
        public void close() throws IOException {
            if (!this.isClone) {
                this.file.close();
            }
        }

        @Override
        public SimpleFSIndexInput clone() {
            SimpleFSIndexInput clone = (SimpleFSIndexInput)super.clone();
            clone.isClone = true;
            return clone;
        }

        @Override
        public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
            return new SimpleFSIndexInput(sliceDescription, this.file, this.off + offset, length, this.getBufferSize());
        }

        @Override
        public final long length() {
            return this.end - this.off;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void readInternal(byte[] b, int offset, int len) throws IOException {
            RandomAccessFile randomAccessFile = this.file;
            synchronized (randomAccessFile) {
                long position = this.off + this.getFilePointer();
                this.file.seek(position);
                if (position + (long)len > this.end) {
                    throw new EOFException("read past EOF: " + this);
                }
                try {
                    int total;
                    int i;
                    for (total = 0; total < len; total += i) {
                        int toRead = Math.min(8192, len - total);
                        i = this.file.read(b, offset + total, toRead);
                        if (i < 0) {
                            throw new EOFException("read past EOF: " + this + " off: " + offset + " len: " + len + " total: " + total + " chunkLen: " + toRead + " end: " + this.end);
                        }
                        assert (i > 0) : "RandomAccessFile.read with non zero-length toRead must always read at least one byte";
                    }
                    assert (total == len);
                }
                catch (IOException ioe) {
                    throw new IOException(ioe.getMessage() + ": " + this, ioe);
                }
            }
        }

        @Override
        protected void seekInternal(long position) {
        }

        boolean isFDValid() throws IOException {
            return this.file.getFD().valid();
        }
    }
}

