/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.upgrade;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;

public class RawRepositoryImpl
implements RawRepository {
    private Session session;
    public static final String QUERY_PREFIX = "SELECT CI.* FROM [deployit:configurationItem] AS ci";

    public RawRepositoryImpl(Session session) {
        this.session = session;
    }

    public void renameType(String oldTypeName, String newTypeName) {
        for (Node node : this.findNodesByType(Type.valueOf((String)oldTypeName))) {
            try {
                node.setProperty("$configuration.item.type", newTypeName);
            }
            catch (RepositoryException e) {
                throw new RuntimeRepositoryException(e);
            }
        }
    }

    public Node read(String nodeId) {
        try {
            return this.session.getNode(nodeId);
        }
        catch (RepositoryException e) {
            throw new RuntimeRepositoryException(e);
        }
    }

    public Node create(String nodeId) {
        try {
            return this.session.getRootNode().addNode(JcrPathHelper.getIdFromAbsolutePath(nodeId));
        }
        catch (RepositoryException e) {
            throw new RuntimeRepositoryException(e);
        }
    }

    public void delete(String nodeId) {
        try {
            this.session.removeItem(nodeId);
        }
        catch (RepositoryException e) {
            throw new RuntimeRepositoryException(e);
        }
    }

    public List<Node> findNodesByType(Type type) {
        ArrayList nodeList = Lists.newArrayList();
        try {
            QueryManager queryManager = this.session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery("SELECT CI.* FROM [deployit:configurationItem] AS ci WHERE ci.[$configuration.item.type] = '" + type.toString() + "'", "JCR-SQL2");
            QueryResult execute = query.execute();
            NodeIterator nodes = execute.getNodes();
            while (nodes.hasNext()) {
                nodeList.add(nodes.nextNode());
            }
        }
        catch (RepositoryException re) {
            throw new RuntimeRepositoryException(re);
        }
        return nodeList;
    }

    public Session getSession() {
        return this.session;
    }

    public static class RuntimeRepositoryException
    extends RuntimeException {
        public RuntimeRepositoryException(Throwable cause) {
            super(cause);
        }
    }
}

