/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.Iterator;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.query.lucene.ExcerptProvider;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.lucene.search.Query;

public class SimpleExcerptProvider
implements ExcerptProvider {
    private ItemStateManager ism;

    @Override
    public void init(Query query, SearchIndex index) throws IOException {
        this.ism = index.getContext().getItemStateManager();
    }

    @Override
    public String getExcerpt(NodeId id, int maxFragments, int maxFragmentSize) throws IOException {
        StringBuffer text = new StringBuffer();
        try {
            NodeState nodeState = (NodeState)this.ism.getItemState(id);
            String separator = "";
            Iterator<Name> it = nodeState.getPropertyNames().iterator();
            while (it.hasNext() && text.length() < maxFragmentSize) {
                InternalValue[] values;
                PropertyId propId = new PropertyId(id, it.next());
                PropertyState propState = (PropertyState)this.ism.getItemState(propId);
                if (propState.getType() != 1) continue;
                text.append(separator);
                separator = " ... ";
                for (InternalValue value : values = propState.getValues()) {
                    text.append(value.toString());
                }
            }
        }
        catch (ItemStateException e) {
            // empty catch block
        }
        if (text.length() > maxFragmentSize) {
            int lastSpace = text.lastIndexOf(" ", maxFragmentSize);
            if (lastSpace != -1) {
                text.setLength(lastSpace);
            } else {
                text.setLength(maxFragmentSize);
            }
            text.append(" ...");
        }
        return "<excerpt><fragment>" + text.toString() + "</fragment></excerpt>";
    }
}

